/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

final class JandexTypeSystem {
    private final IndexView index;
    private static final Type ERASURE = ClassType.create((String)"ERASURE PLACEHOLDER");

    static JandexTypeSystem of(IndexView index) {
        Objects.requireNonNull(index);
        return new JandexTypeSystem(index);
    }

    private JandexTypeSystem(IndexView index) {
        this.index = index;
    }

    List<Type> typeWithSuperTypes(Type type, boolean skipInterfaces) {
        Objects.requireNonNull(type);
        if (type.kind() != Type.Kind.CLASS && type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalArgumentException("Type must be class or parameterized, got " + String.valueOf(type.kind()) + ": " + String.valueOf(type));
        }
        ArrayList<Type> result = new ArrayList<Type>();
        result.add(type);
        ClassInfo clazz = this.requireClass(type);
        Function<String, Type> substitution = this.createSubstitution(clazz, type);
        if (!clazz.isInterface()) {
            while (!clazz.name().equals((Object)DotName.OBJECT_NAME)) {
                type = this.substituteTypeVariables(clazz.superClassType(), substitution);
                result.add(type);
                clazz = this.requireClass(type);
                substitution = this.createSubstitution(clazz, type);
            }
        }
        if (skipInterfaces) {
            return result;
        }
        HashSet<DotName> seen = new HashSet<DotName>();
        ArrayDeque<Type> worklist = new ArrayDeque<Type>(result);
        while (!worklist.isEmpty()) {
            Type item = (Type)worklist.removeFirst();
            clazz = this.requireClass(item);
            substitution = this.createSubstitution(clazz, item);
            for (Type interfaceType : clazz.interfaceTypes()) {
                if (!seen.add(interfaceType.name())) continue;
                interfaceType = this.substituteTypeVariables(interfaceType, substitution);
                result.add(interfaceType);
                worklist.add(interfaceType);
            }
        }
        return result;
    }

    List<MethodKey> methods(Type type, Predicate<MethodInfo> filter) {
        ClassInfo clazz = this.requireClass(type);
        Function<String, Type> substitution = this.createSubstitution(clazz, type);
        List methods = clazz.methods();
        ArrayList<MethodKey> result = new ArrayList<MethodKey>(methods.size());
        for (MethodInfo method : methods) {
            if (!filter.test(method)) continue;
            Type returnType = this.substituteTypeVariables(method.returnType(), substitution);
            Type[] parameterTypes = new Type[method.parametersCount()];
            for (int i = 0; i < method.parametersCount(); ++i) {
                parameterTypes[i] = this.substituteTypeVariables(method.parameterType(i), substitution);
            }
            result.add(new MethodKey(method.name(), Arrays.asList(parameterTypes), returnType));
        }
        return result;
    }

    private Function<String, Type> createSubstitution(ClassInfo declaration, Type type) {
        if (!declaration.name().equals((Object)type.name())) {
            throw new IllegalArgumentException("Type must refer to the given declaration, got " + String.valueOf(declaration.name()) + " and " + String.valueOf(type));
        }
        if (declaration.typeParameters().isEmpty()) {
            return ignored -> null;
        }
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return ignored -> ERASURE;
        }
        List typeParameters = declaration.typeParameters();
        List typeArguments = type.asParameterizedType().arguments();
        if (typeParameters.size() != typeArguments.size()) {
            throw new IllegalArgumentException("Declaration has " + typeParameters.size() + " type parameters, but its type use has " + typeArguments.size() + " type arguments");
        }
        if (typeParameters.isEmpty()) {
            return ignored -> null;
        }
        if (typeParameters.size() == 1) {
            String typeParamId = ((TypeVariable)typeParameters.get(0)).identifier();
            Type typeArg = (Type)typeArguments.get(0);
            return id -> id.equals(typeParamId) ? typeArg : null;
        }
        if (typeParameters.size() == 2) {
            String typeParamId1 = ((TypeVariable)typeParameters.get(0)).identifier();
            Type typeArg1 = (Type)typeArguments.get(0);
            String typeParamId2 = ((TypeVariable)typeParameters.get(1)).identifier();
            Type typeArg2 = (Type)typeArguments.get(1);
            return id -> {
                if (id.equals(typeParamId1)) {
                    return typeArg1;
                }
                if (id.equals(typeParamId2)) {
                    return typeArg2;
                }
                return null;
            };
        }
        HashMap<String, Type> data = new HashMap<String, Type>((int)((double)typeParameters.size() * 1.5));
        for (int i = 0; i < typeParameters.size(); ++i) {
            data.put(((TypeVariable)typeParameters.get(i)).identifier(), (Type)typeArguments.get(i));
        }
        return data::get;
    }

    private Type substituteTypeVariables(Type type, Function<String, Type> substitution) {
        Objects.requireNonNull(substitution);
        Object result = null;
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case CLASS: {
                return type;
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                Type substitutedConstituent = this.substituteTypeVariables(arrayType.constituent(), substitution);
                return ArrayType.create((Type)substitutedConstituent, (int)arrayType.dimensions());
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                List typeArgs = parameterizedType.arguments();
                Type[] substitutedTypeArgs = new Type[typeArgs.size()];
                for (int i = 0; i < typeArgs.size(); ++i) {
                    substitutedTypeArgs[i] = this.substituteTypeVariables((Type)typeArgs.get(i), substitution);
                }
                Type substitutedOwner = parameterizedType.owner() != null ? this.substituteTypeVariables(parameterizedType.owner(), substitution) : null;
                return ParameterizedType.create((DotName)type.name(), (Type[])substitutedTypeArgs, (Type)substitutedOwner);
            }
            case TYPE_VARIABLE: {
                return this.callSubstitution(type.asTypeVariable().identifier(), type, substitution);
            }
            case TYPE_VARIABLE_REFERENCE: {
                return this.callSubstitution(type.asTypeVariableReference().identifier(), type, substitution);
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return this.callSubstitution(type.asUnresolvedTypeVariable().identifier(), type, substitution);
            }
            case WILDCARD_TYPE: {
                boolean hasImplicitObjectBound;
                WildcardType wildcardType = type.asWildcardType();
                boolean isExtends = wildcardType.superBound() == null;
                boolean bl = hasImplicitObjectBound = isExtends && wildcardType.extendsBound() == ClassType.OBJECT_TYPE;
                if (hasImplicitObjectBound) {
                    return type;
                }
                if (isExtends) {
                    return WildcardType.createUpperBound((Type)this.substituteTypeVariables(wildcardType.extendsBound(), substitution));
                }
                return WildcardType.createLowerBound((Type)this.substituteTypeVariables(wildcardType.superBound(), substitution));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(this));
    }

    private Type callSubstitution(String typeVarId, Type typeVar, Function<String, Type> substitution) {
        Type substituted = substitution.apply(typeVarId);
        if (substituted == null) {
            return typeVar;
        }
        if (substituted == ERASURE) {
            return ClassType.create((DotName)typeVar.name());
        }
        return substituted;
    }

    private ClassInfo requireClass(Type type) {
        return this.requireClass(type.name());
    }

    private ClassInfo requireClass(DotName name) {
        ClassInfo clazz = this.index.getClassByName(name);
        if (clazz == null) {
            throw new IllegalStateException("Index does not include class " + String.valueOf(name));
        }
        return clazz;
    }

    record MethodKey(String name, List<Type> parameterTypes, Type returnType) {
        public void appendTo(StringBuilder str) {
            str.append(this.returnType).append(" ").append(this.name).append("(");
            boolean first = true;
            for (Type parameterType : this.parameterTypes) {
                if (!first) {
                    str.append(", ");
                }
                str.append(parameterType);
                first = false;
            }
            str.append(")");
        }

        @Override
        public String toString() {
            StringBuilder str = new StringBuilder();
            this.appendTo(str);
            return str.toString();
        }
    }
}

