/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.JandexTypeSystem;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Types;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class Decorators {
    static final Logger LOGGER = Logger.getLogger(Decorators.class);

    private Decorators() {
    }

    static DecoratorInfo createDecorator(ClassInfo decoratorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        ArrayList<InjectionPointInfo> delegateInjectionPoints = new ArrayList<InjectionPointInfo>();
        List<Injection> injections = Injection.forBean((AnnotationTarget)decoratorClass, null, beanDeployment, transformer, Injection.BeanType.DECORATOR);
        for (Injection injection : injections) {
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                if (!injectionPoint.isDelegate()) continue;
                delegateInjectionPoints.add(injectionPoint);
            }
        }
        if (delegateInjectionPoints.isEmpty()) {
            throw new DefinitionException("The decorator " + String.valueOf(decoratorClass) + " has no @Delegate injection point");
        }
        if (delegateInjectionPoints.size() > 1) {
            throw new DefinitionException("The decorator " + String.valueOf(decoratorClass) + " has multiple @Delegate injection points: " + String.valueOf(delegateInjectionPoints));
        }
        InjectionPointInfo delegateInjectionPoint = (InjectionPointInfo)delegateInjectionPoints.get(0);
        Integer priority = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)decoratorClass)) {
            ScopeInfo scopeAnnotation;
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if ((scopeAnnotation = beanDeployment.getScope(annotation.name())) == null || BuiltinScope.DEPENDENT.is(scopeAnnotation)) continue;
            throw new DefinitionException("A decorator must be @Dependent but " + String.valueOf(decoratorClass) + " declares " + String.valueOf(scopeAnnotation.getDotName()));
        }
        Types.TypeClosure typeClosure = Types.getClassBeanTypeClosure(decoratorClass, beanDeployment);
        Set<Type> types = typeClosure.types();
        HashSet<Type> decoratedTypes = new HashSet<Type>();
        for (Type type : types) {
            ClassInfo clazz;
            if (type.name().equals((Object)DotNames.SERIALIZABLE) || !Modifier.isInterface((clazz = beanDeployment.getBeanArchiveIndex().getClassByName(type.name())).flags())) continue;
            decoratedTypes.add(type);
        }
        if (decoratedTypes.isEmpty()) {
            throw new DefinitionException("The decorator " + String.valueOf(decoratorClass) + " has no decorated type");
        }
        Set<Type> delegateTypes = Types.getDelegateTypeClosure(delegateInjectionPoint, beanDeployment);
        for (Type decoratedType : decoratedTypes) {
            if (!delegateTypes.contains(decoratedType)) {
                throw new DefinitionException("The delegate type " + String.valueOf(delegateInjectionPoint.getRequiredType()) + " does not implement the decorated type: " + String.valueOf(decoratedType));
            }
            for (BuiltinBean builtinBean : BuiltinBean.values()) {
                if (builtinBean.equals((Object)BuiltinBean.RESOURCE) || !builtinBean.hasRawTypeDotName(decoratedType.name())) continue;
                throw new UnsupportedOperationException("Decorating built-in bean types is not supported! Decorator " + String.valueOf(decoratorClass) + " is attempting to decorate " + String.valueOf(decoratedType.name()));
            }
        }
        if (priority == null) {
            if (beanDeployment.strictCompatibility) {
                return null;
            }
            LOGGER.info((Object)("The decorator " + String.valueOf(decoratorClass) + " does not declare any @Priority. It will be assigned a default priority value of 0."));
            priority = 0;
        }
        if (Modifier.isAbstract(decoratorClass.flags())) {
            JandexTypeSystem jandexTypeSystem = JandexTypeSystem.of(beanDeployment.getBeanArchiveIndex());
            HashSet<JandexTypeSystem.MethodKey> abstractMethodsOnDecoratedTypes = new HashSet<JandexTypeSystem.MethodKey>();
            for (Type decoratedType : decoratedTypes) {
                abstractMethodsOnDecoratedTypes.addAll(jandexTypeSystem.methods(decoratedType, MethodInfo::isAbstract));
            }
            HashSet<JandexTypeSystem.MethodKey> badAbstractMethods = new HashSet<JandexTypeSystem.MethodKey>();
            for (Type superclassType : jandexTypeSystem.typeWithSuperTypes(Types.getProviderType(decoratorClass), true)) {
                for (JandexTypeSystem.MethodKey method : jandexTypeSystem.methods(superclassType, MethodInfo::isAbstract)) {
                    if (abstractMethodsOnDecoratedTypes.contains(method)) continue;
                    badAbstractMethods.add(method);
                }
            }
            if (!badAbstractMethods.isEmpty()) {
                StringBuilder message = new StringBuilder("Abstract decorator ").append(decoratorClass.name()).append(" declares abstract method(s) not present on decorated interface(s):\n");
                for (JandexTypeSystem.MethodKey methodKey : badAbstractMethods) {
                    message.append("\t- ");
                    methodKey.appendTo(message);
                    message.append("\n");
                }
                throw new DefinitionException(message.toString());
            }
        }
        Decorators.checkDecoratorFieldsAndMethods(decoratorClass, beanDeployment);
        return new DecoratorInfo((AnnotationTarget)decoratorClass, beanDeployment, delegateInjectionPoint, decoratedTypes, injections, priority);
    }

    private static void checkDecoratorFieldsAndMethods(ClassInfo decoratorClass, BeanDeployment beanDeployment) {
        ClassInfo aClass = decoratorClass;
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                    throw new DefinitionException("Decorator declares a producer method: " + String.valueOf(decoratorClass));
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("Decorator declares a disposer method: " + String.valueOf(decoratorClass));
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                    throw new DefinitionException("Decorator declares an observer method: " + String.valueOf(decoratorClass));
                }
                if (!beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Decorator declares an async observer method: " + String.valueOf(decoratorClass));
            }
            for (FieldInfo field : aClass.fields()) {
                if (!beanDeployment.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("Decorator declares a producer field: " + String.valueOf(decoratorClass));
            }
            DotName superClass = aClass.superName();
            aClass = superClass != null && !superClass.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClass) : null;
        }
    }
}

