/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class Annotations {
    private Annotations() {
    }

    public static AnnotationInstance find(Collection<AnnotationInstance> annotations, DotName name) {
        if (annotations.isEmpty()) {
            return null;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            if (!annotationInstance.name().equals((Object)name)) continue;
            return annotationInstance;
        }
        return null;
    }

    public static boolean contains(Collection<AnnotationInstance> annotations, DotName name) {
        return Annotations.find(annotations, name) != null;
    }

    public static boolean containsAny(Collection<AnnotationInstance> annotations, Iterable<DotName> names) {
        if (annotations.isEmpty()) {
            return false;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            for (DotName name : names) {
                if (!annotationInstance.name().equals((Object)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<AnnotationInstance> getParameterAnnotations(Collection<AnnotationInstance> annotations) {
        return Annotations.getAnnotations(AnnotationTarget.Kind.METHOD_PARAMETER, annotations);
    }

    public static Set<AnnotationInstance> getAnnotations(AnnotationTarget.Kind kind, Collection<AnnotationInstance> annotations) {
        return Annotations.getAnnotations(kind, null, annotations);
    }

    public static Set<AnnotationInstance> getAnnotations(AnnotationTarget.Kind kind, DotName name, Collection<AnnotationInstance> annotations) {
        if (annotations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AnnotationInstance> ret = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : annotations) {
            if (kind != annotation.target().kind() || name != null && !annotation.name().equals((Object)name)) continue;
            ret.add(annotation);
        }
        return ret;
    }

    public static boolean hasParameterAnnotation(BeanDeployment beanDeployment, MethodInfo method, DotName name) {
        return Annotations.contains(Annotations.getParameterAnnotations(beanDeployment, method), name);
    }

    public static Set<AnnotationInstance> getParameterAnnotations(BeanDeployment beanDeployment, MethodInfo method) {
        HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)method)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind()) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static Set<AnnotationInstance> getParameterAnnotations(BeanDeployment beanDeployment, MethodInfo method, int position) {
        return Annotations.getParameterAnnotations(beanDeployment::getAnnotations, method, position);
    }

    public static Set<AnnotationInstance> getParameterAnnotations(Function<AnnotationTarget, Collection<AnnotationInstance>> transformedAnnotations, MethodInfo method, int position) {
        HashSet<AnnotationInstance> annotations = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : transformedAnnotations.apply((AnnotationTarget)method)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind() || annotation.target().asMethodParameter().position() != position) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static AnnotationInstance getParameterAnnotation(MethodInfo method, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            if (!annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) || !annotationInstance.name().equals((Object)annotation)) continue;
            return annotationInstance;
        }
        return null;
    }

    public static Collection<AnnotationInstance> onlyRuntimeVisible(Collection<AnnotationInstance> annotations) {
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>(annotations.size());
        for (AnnotationInstance annotation : annotations) {
            if (!annotation.runtimeVisible()) continue;
            result.add(annotation);
        }
        return result;
    }

    public static List<AnnotationInstance> uniqueAnnotations(Set<AnnotationInstance> annotations) {
        HashSet<AnnotationInstanceEquivalenceProxy> proxies = new HashSet<AnnotationInstanceEquivalenceProxy>();
        for (AnnotationInstance annotation : annotations) {
            proxies.add(annotation.createEquivalenceProxy());
        }
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>(proxies.size());
        for (AnnotationInstanceEquivalenceProxy proxy : proxies) {
            result.add(proxy.get());
        }
        return result;
    }

    public static AnnotationInstance jandexAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = Annotations.annotationType(annotation);
        DotName name = DotName.createSimple((String)annotationType.getName());
        AnnotationValue[] jandexAnnotationValues = Annotations.jandexAnnotationValues(annotationType, annotation);
        return AnnotationInstance.create((DotName)name, null, (AnnotationValue[])jandexAnnotationValues);
    }

    private static Class<? extends Annotation> annotationType(Annotation annotation) {
        Class annotationType = null;
        ArrayDeque candidates = new ArrayDeque();
        candidates.add(annotation.getClass());
        while (!candidates.isEmpty()) {
            Class candidate = (Class)candidates.remove();
            if (candidate.isAnnotation()) {
                annotationType = candidate;
                break;
            }
            Collections.addAll(candidates, candidate.getInterfaces());
        }
        if (annotationType == null) {
            throw new IllegalArgumentException("Not an annotation: " + String.valueOf(annotation));
        }
        return annotationType;
    }

    private static <A extends Annotation> AnnotationValue[] jandexAnnotationValues(Class<A> annotationType, A annotationInstance) {
        ArrayList<AnnotationValue> result = new ArrayList<AnnotationValue>();
        for (Method member : annotationType.getDeclaredMethods()) {
            try {
                if (!member.canAccess(annotationInstance)) {
                    member.setAccessible(true);
                }
                result.add(Annotations.jandexAnnotationValue(member.getName(), member.invoke(annotationInstance, new Object[0])));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return result.toArray(new AnnotationValue[0]);
    }

    private static AnnotationValue jandexAnnotationValue(String name, Object value) {
        if (value instanceof Boolean) {
            return AnnotationValue.createBooleanValue((String)name, (boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return AnnotationValue.createByteValue((String)name, (byte)((Byte)value));
        }
        if (value instanceof Short) {
            return AnnotationValue.createShortValue((String)name, (short)((Short)value));
        }
        if (value instanceof Integer) {
            return AnnotationValue.createIntegerValue((String)name, (int)((Integer)value));
        }
        if (value instanceof Long) {
            return AnnotationValue.createLongValue((String)name, (long)((Long)value));
        }
        if (value instanceof Float) {
            return AnnotationValue.createFloatValue((String)name, (float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return AnnotationValue.createDoubleValue((String)name, (double)((Double)value));
        }
        if (value instanceof Character) {
            return AnnotationValue.createCharacterValue((String)name, (char)((Character)value).charValue());
        }
        if (value instanceof String) {
            return AnnotationValue.createStringValue((String)name, (String)((String)value));
        }
        if (value instanceof Enum) {
            return AnnotationValue.createEnumValue((String)name, (DotName)DotName.createSimple((String)((Enum)value).getDeclaringClass().getName()), (String)((Enum)value).name());
        }
        if (value instanceof Class) {
            return AnnotationValue.createClassValue((String)name, (Type)Types.jandexType((Class)value));
        }
        if (value.getClass().isAnnotation()) {
            Class<? extends Annotation> annotationType = Annotations.annotationType((Annotation)value);
            AnnotationValue[] jandexAnnotationValues = Annotations.jandexAnnotationValues(annotationType, (Annotation)value);
            AnnotationInstance jandexAnnotation = AnnotationInstance.create((DotName)DotName.createSimple((String)annotationType.getName()), null, (AnnotationValue[])jandexAnnotationValues);
            return AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation);
        }
        if (value.getClass().isArray()) {
            AnnotationValue[] jandexAnnotationValues = (AnnotationValue[])Arrays.stream(Annotations.boxArray(value)).map(it -> Annotations.jandexAnnotationValue(name, it)).toArray(AnnotationValue[]::new);
            return AnnotationValue.createArrayValue((String)name, (AnnotationValue[])jandexAnnotationValues);
        }
        throw new IllegalArgumentException("Unknown annotation attribute value: " + String.valueOf(value));
    }

    private static Object[] boxArray(Object value) {
        if (value instanceof boolean[]) {
            boolean[] primitiveArray = (boolean[])value;
            Object[] boxedArray = new Boolean[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof byte[]) {
            byte[] primitiveArray = (byte[])value;
            Object[] boxedArray = new Byte[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof short[]) {
            short[] primitiveArray = (short[])value;
            Object[] boxedArray = new Short[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof int[]) {
            int[] primitiveArray = (int[])value;
            Object[] boxedArray = new Integer[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof long[]) {
            long[] primitiveArray = (long[])value;
            Object[] boxedArray = new Long[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof float[]) {
            float[] primitiveArray = (float[])value;
            Object[] boxedArray = new Float[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = Float.valueOf(primitiveArray[i]);
            }
            return boxedArray;
        }
        if (value instanceof double[]) {
            double[] primitiveArray = (double[])value;
            Object[] boxedArray = new Double[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof char[]) {
            char[] primitiveArray = (char[])value;
            Object[] boxedArray = new Character[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = Character.valueOf(primitiveArray[i]);
            }
            return boxedArray;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new IllegalArgumentException("Not an array: " + String.valueOf(value));
    }
}

