/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InterceptorCreator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.ConfiguratorBase;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Type;

public final class InterceptorConfigurator
extends ConfiguratorBase<InterceptorConfigurator> {
    private final BeanDeployment beanDeployment;
    final InterceptionType type;
    final Set<InjectionPointInfo.TypeAndQualifiers> injectionPoints;
    final Set<AnnotationInstance> bindings;
    String identifier;
    int priority;

    InterceptorConfigurator(BeanDeployment beanDeployment, InterceptionType type) {
        this.beanDeployment = beanDeployment;
        this.type = type;
        this.injectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
        this.bindings = new HashSet<AnnotationInstance>();
        this.priority = 1;
    }

    public InterceptorConfigurator priority(int priority) {
        this.priority = priority;
        return this;
    }

    public InterceptorConfigurator identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public InterceptorConfigurator bindings(AnnotationInstance ... bindings) {
        Collections.addAll(this.bindings, bindings);
        return this;
    }

    public InterceptorConfigurator addInjectionPoint(Type requiredType, AnnotationInstance ... requiredQualifiers) {
        this.injectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(requiredType, requiredQualifiers.length == 0 ? Set.of(AnnotationInstance.builder(Default.class).build()) : Set.of(requiredQualifiers)));
        return this;
    }

    public void creator(Class<? extends InterceptorCreator> creatorClass) {
        this.beanDeployment.addSyntheticInterceptor(new InterceptorInfo(creatorClass, this.beanDeployment, this.bindings, List.of(Injection.forSyntheticInterceptor(this.injectionPoints)), this.priority, this.type, this.params, this.identifier));
    }
}

