/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StandardExports
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(StandardExports.class.getName());
    private final StatusReader statusReader;
    private final OperatingSystemMXBean osBean;
    private final RuntimeMXBean runtimeBean;
    private final boolean unix;
    private final boolean linux;
    private static final double KB = 1024.0;

    public StandardExports() {
        this(new StatusReader(), (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getRuntimeMXBean());
    }

    StandardExports(StatusReader statusReader, OperatingSystemMXBean osBean, RuntimeMXBean runtimeBean) {
        this.statusReader = statusReader;
        this.osBean = osBean;
        this.runtimeBean = runtimeBean;
        this.unix = osBean instanceof UnixOperatingSystemMXBean;
        this.linux = osBean.getName().indexOf("Linux") == 0;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add((Collector.MetricFamilySamples)new CounterMetricFamily("process_cpu_seconds_total", "Total user and system CPU time spent in seconds.", (double)this.osBean.getProcessCpuTime() / 1.0E9));
        mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("process_start_time_seconds", "Start time of the process since unix epoch in seconds.", (double)this.runtimeBean.getStartTime() / 1000.0));
        if (this.unix) {
            UnixOperatingSystemMXBean unixBean = (UnixOperatingSystemMXBean)this.osBean;
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("process_open_fds", "Number of open file descriptors.", (double)unixBean.getOpenFileDescriptorCount()));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("process_max_fds", "Maximum number of open file descriptors.", (double)unixBean.getMaxFileDescriptorCount()));
        }
        if (this.linux) {
            try {
                this.collectMemoryMetricsLinux(mfs);
            }
            catch (Exception e) {
                LOGGER.warning(e.toString());
            }
        }
        return mfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectMemoryMetricsLinux(List<Collector.MetricFamilySamples> mfs) {
        BufferedReader br = null;
        try {
            String line;
            br = this.statusReader.procSelfStatusReader();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("VmSize:")) {
                    mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("process_virtual_memory_bytes", "Virtual memory size in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
                    continue;
                }
                if (!line.startsWith("VmRSS:")) continue;
                mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("process_resident_memory_bytes", "Resident memory size in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
            }
        }
        catch (IOException e) {
            LOGGER.fine(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.fine(e.toString());
                }
            }
        }
    }

    static class StatusReader {
        StatusReader() {
        }

        BufferedReader procSelfStatusReader() throws FileNotFoundException {
            return new BufferedReader(new FileReader("/proc/self/status"));
        }
    }
}

