/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public final class JdbcAttributesGetter
implements SqlClientAttributesGetter<DbRequest, Void> {
    public static final JdbcAttributesGetter INSTANCE = new JdbcAttributesGetter();

    @Nullable
    public String getDbSystem(DbRequest request) {
        return request.getDbInfo().getSystem();
    }

    @Deprecated
    @Nullable
    public String getUser(DbRequest request) {
        return request.getDbInfo().getUser();
    }

    @Nullable
    public String getDbNamespace(DbRequest request) {
        DbInfo dbInfo = request.getDbInfo();
        return dbInfo.getName() == null ? dbInfo.getDb() : dbInfo.getName();
    }

    @Deprecated
    @Nullable
    public String getConnectionString(DbRequest request) {
        return request.getDbInfo().getShortUrl();
    }

    public Collection<String> getRawQueryTexts(DbRequest request) {
        return request.getQueryTexts();
    }

    public Long getBatchSize(DbRequest request) {
        return request.getBatchSize();
    }

    @Nullable
    public String getResponseStatus(@Nullable Void response, @Nullable Throwable error) {
        if (error instanceof SQLException) {
            return Integer.toString(((SQLException)error).getErrorCode());
        }
        return null;
    }

    public Map<String, String> getQueryParameters(DbRequest request) {
        return request.getPreparedStatementParameters();
    }

    @Nullable
    public String getServerAddress(DbRequest request) {
        return request.getDbInfo().getHost();
    }

    @Nullable
    public Integer getServerPort(DbRequest request) {
        return request.getDbInfo().getPort();
    }
}

