/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.jakarta9.instrument.jms.DefaultJmsProcessObservationConvention;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MessageConsumerInvocationHandler
implements InvocationHandler {
    private static final JmsProcessObservationConvention DEFAULT_CONVENTION = new DefaultJmsProcessObservationConvention();
    private final MessageConsumer target;
    private final ObservationRegistry registry;

    MessageConsumerInvocationHandler(MessageConsumer target, ObservationRegistry registry) {
        this.target = target;
        this.registry = registry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if ("setMessageListener".equals(method.getName()) && args[0] != null) {
                MessageListener listener = (MessageListener)args[0];
                return method.invoke((Object)this.target, new ObservedMessageListener(listener, this.registry));
            }
            return method.invoke((Object)this.target, args);
        }
        catch (InvocationTargetException exc) {
            throw exc.getTargetException();
        }
    }

    static class ObservedMessageListener
    implements MessageListener {
        private final MessageListener delegate;
        private final ObservationRegistry registry;

        ObservedMessageListener(MessageListener delegate, ObservationRegistry registry) {
            this.delegate = delegate;
            this.registry = registry;
        }

        public void onMessage(Message message) {
            Observation observation = JmsObservationDocumentation.JMS_MESSAGE_PROCESS.observation(null, DEFAULT_CONVENTION, () -> new JmsProcessObservationContext(message), this.registry);
            observation.observe(() -> this.delegate.onMessage(message));
        }
    }
}

