/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.metadata.strategy.query.OperationNameGenerator;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReturnTypeOperationNameGenerator
implements OperationNameGenerator {
    @Override
    public String generateQueryName(Method queryElement, AnnotatedType type, Object instance) {
        String name = queryElement.getReturnType().getSimpleName().toLowerCase();
        if (queryElement.getReturnType().isArray() || Iterable.class.isAssignableFrom(queryElement.getReturnType())) {
            return this.pluralize(name);
        }
        return name;
    }

    @Override
    public String generateQueryName(Field queryField, AnnotatedType declaringType, Object instance) {
        String name = queryField.getType().getSimpleName().toLowerCase();
        if (queryField.getType().isArray() || Iterable.class.isAssignableFrom(queryField.getType())) {
            return this.pluralize(name);
        }
        return name;
    }

    @Override
    public String generateMutationName(Method mutationMethod, AnnotatedType declaringType, Object instance) {
        return this.generateQueryName(mutationMethod, declaringType, instance);
    }

    protected String pluralize(String noun) {
        if (noun.endsWith("man")) {
            return noun.substring(noun.length() - 3) + "en";
        }
        if (noun.endsWith("s") || noun.endsWith("x") || noun.endsWith("ch")) {
            return noun + "es";
        }
        if (noun.endsWith("y")) {
            return noun.substring(noun.length() - 2) + "ies";
        }
        return noun + "s";
    }
}

