/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.dockerui;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ProxyDetails {
    private final ServletContext servletContext;
    private boolean debug = true;
    private String stringProxyURL;
    private String hostAndPort;
    private String path = "";
    private String userName;
    private String password;
    private String host;
    private int port = 80;
    public static final String USER_PARAM = "_user";
    public static final String PWD_PARAM = "_pwd";
    private static Set<String> ignoreHeaderNames = new HashSet<String>(Arrays.asList("_user", "_pwd", "_url", "url"));

    public ProxyDetails(String hostAndPort, HttpServletRequest httpServletRequest, ServletContext servletContext) {
        this.hostAndPort = hostAndPort;
        this.servletContext = servletContext;
        String path = httpServletRequest.getPathInfo();
        if (path == null) {
            path = "";
        }
        this.stringProxyURL = hostAndPort + path;
        try {
            Enumeration iter = httpServletRequest.getParameterNames();
            while (iter.hasMoreElements()) {
                String[] values;
                String name;
                Object next = iter.nextElement();
                if (!(next instanceof String) || ignoreHeaderNames.contains(name = next.toString())) continue;
                for (String value : values = httpServletRequest.getParameterValues(name)) {
                    String prefix = "?";
                    if (this.stringProxyURL.contains("?")) {
                        prefix = "&";
                    }
                    this.stringProxyURL = this.stringProxyURL + prefix + name + "=" + value;
                }
            }
            if (this.debug) {
                try {
                    servletContext.log("Proxying to " + this.stringProxyURL + " as user: " + this.userName);
                }
                catch (Exception e) {}
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected int indexOf(String text, String ... values) {
        int answer = -1;
        for (String value : values) {
            int idx = text.indexOf(value);
            if (idx < 0 || answer >= 0 && idx >= answer) continue;
            answer = idx;
        }
        return answer;
    }

    public String getStringProxyURL() {
        return this.stringProxyURL;
    }

    public String getProxyHostAndPort() {
        return this.hostAndPort;
    }

    public String getProxyPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.hostAndPort != null;
    }
}

