/*
 * Copyright 2006-2015 The MZmine 2 Development Team
 * 
 * This file is part of MZmine 2.
 * 
 * MZmine 2 is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * MZmine 2 is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * MZmine 2; if not, write to the Free Software Foundation, Inc., 51 Franklin
 * St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package io.github.msdk.featuredetection.gridmass;

class Probe implements Comparable<Probe> {
    double mz;
    int scan;
    double mzCenter;
    int scanCenter;
    double intensityCenter = -1;

    Probe(double mz, int scan) {
	this.mz = this.mzCenter = mz;
	this.scan = this.scanCenter = scan;
    }

    /**
     * <p>compareTo.</p>
     *
     * @param other a {@link io.github.msdk.featuredetection.gridmass.Probe} object.
     * @return a int.
     */
    public int compareTo(Probe other) {
	if (other == null)
	    return -1;

	if (mzCenter < other.mzCenter)
	    return -1;
	if (mzCenter > other.mzCenter)
	    return 1;

	if (scanCenter < other.scanCenter)
	    return -1;
	if (scanCenter > other.scanCenter)
	    return 1;

	return 0;
    }

}
