/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.opensymphony.xwork2.ActionContext;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Idable;
import fr.ird.t3.entities.reference.OceanImpl;
import fr.ird.t3.services.DecoratorService;
import fr.ird.t3.services.DefaultT3ServiceContext;
import fr.ird.t3.services.FreeMarkerService;
import fr.ird.t3.services.IOCService;
import fr.ird.t3.services.T3InputService;
import fr.ird.t3.services.T3OutputService;
import fr.ird.t3.services.T3Service;
import fr.ird.t3.services.T3ServiceContext;
import fr.ird.t3.services.T3ServiceFactory;
import fr.ird.t3.services.UserService;
import fr.ird.t3.services.ZoneStratumService;
import fr.ird.t3.web.T3ApplicationContext;
import fr.ird.t3.web.T3InternalTransactionFilter;
import fr.ird.t3.web.T3Session;
import fr.ird.t3.web.T3UserTransactionFilter;
import fr.ird.t3.web.actions.admin.TripListModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaTransactionAware;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.TimeLog;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.web.struts2.BaseAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class T3ActionSupport
extends BaseAction
implements TopiaTransactionAware {
    private static final long serialVersionUID = 1L;
    public static final String LOG_LINE = "--------------------------------------------------------------------------------";
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat monthFormat;
    protected transient TopiaContext transaction;
    protected transient TopiaContext internalTransaction;
    protected transient T3ServiceFactory serviceFactory;
    private transient T3ServiceContext serviceContext;
    private static final Log log = LogFactory.getLog(T3ActionSupport.class);
    public static final TimeLog TIME_LOG = new TimeLog(T3ActionSupport.class);

    public static T3ApplicationContext getT3ApplicationContext() {
        ActionContext actionContext = T3ActionSupport.getActionContext();
        T3ApplicationContext applicationContext = T3ApplicationContext.getT3ApplicationContext((ActionContext)actionContext);
        return applicationContext;
    }

    protected T3Configuration getApplicationConfiguration() {
        return T3ActionSupport.getT3ApplicationContext().getConfiguration();
    }

    public T3ServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new T3ServiceFactory();
        }
        return this.serviceFactory;
    }

    protected T3ServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = DefaultT3ServiceContext.newContext((Locale)this.getLocale(), (TopiaContext)this.getInternalTransaction(), (TopiaContext)this.getTransaction(), (T3Configuration)this.getApplicationConfiguration(), (T3ServiceFactory)this.getServiceFactory());
        }
        return this.serviceContext;
    }

    protected T3Session getT3Session() {
        return T3Session.getT3Session((ActionContext)T3ActionSupport.getActionContext());
    }

    protected <C> C getActionConfiguration(Class<C> configurationClass) {
        return (C)this.getT3Session().getActionConfiguration(configurationClass);
    }

    public static String getApplicationVersion() {
        return T3ActionSupport.getApplicationConfig().getApplicationVersion();
    }

    public static T3Configuration getApplicationConfig() {
        return T3ActionSupport.getT3ApplicationContext().getConfiguration();
    }

    public final DecoratorService getDecoratorService() {
        return (DecoratorService)this.newService(DecoratorService.class);
    }

    public final FreeMarkerService getFreeMarkerService() {
        return (FreeMarkerService)this.newService(FreeMarkerService.class);
    }

    public final IOCService getIocService() {
        return (IOCService)this.newService(IOCService.class);
    }

    public final ZoneStratumService getZoneStratumService() {
        return (ZoneStratumService)this.newService(ZoneStratumService.class);
    }

    public final T3InputService getT3InputService() {
        return (T3InputService)this.newService(T3InputService.class);
    }

    public final T3OutputService getT3OutputService() {
        return (T3OutputService)this.newService(T3OutputService.class);
    }

    public final UserService getUserService() {
        return (UserService)this.newService(UserService.class);
    }

    public <O> Decorator<O> getDecorator(Class<O> type) {
        Decorator decorator = this.getDecorator(type, null);
        return decorator;
    }

    public String decorate(Object o) {
        Decorator decorator = this.getDecorator(o.getClass());
        String result = decorator.toString(o);
        return result;
    }

    public <O> Collection<String> decorate(Class<O> type, Collection<O> objects) {
        Decorator decorator = this.getDecorator(type);
        ArrayList result = Lists.newArrayList();
        for (O object : objects) {
            String s = decorator.toString(object);
            result.add(s);
        }
        return result;
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String context) {
        Decorator decorator = this.getDecoratorService().getDecorator(this.getLocale(), type, context);
        return decorator;
    }

    public String formatDate(Date date) {
        String result = this.getDateFormat().format(date);
        return result;
    }

    public String formatMonth(Date date) {
        String result = this.getMonthFormat().format(date);
        return result;
    }

    public final TopiaContext getInternalTransaction() {
        if (this.internalTransaction == null) {
            HttpServletRequest request = (HttpServletRequest)T3ActionSupport.getActionContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.internalTransaction = T3InternalTransactionFilter.getTransaction((ServletRequest)request);
        }
        return this.internalTransaction;
    }

    public final TopiaContext getTransaction() {
        if (this.transaction == null) {
            HttpServletRequest request = (HttpServletRequest)T3ActionSupport.getActionContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.transaction = T3UserTransactionFilter.getTransaction((ServletRequest)request);
        }
        return this.transaction;
    }

    public final void setTransaction(TopiaContext transaction) {
        throw new UnsupportedOperationException();
    }

    protected void injectExcept(Class<?> ... annotations) throws Exception {
        this.getIocService().injectExcept((Object)this, (Class[])annotations);
    }

    protected void injectOnly(Class<?> ... annotations) throws Exception {
        this.getIocService().injectOnly((Object)this, (Class[])annotations);
    }

    protected <E extends T3Service> E newService(Class<E> clazz) {
        return (E)this.getServiceContext().newService(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContentInFile(T3Session session, String content) {
        File userLogfile = session.getUserLogFile();
        try {
            FileWriter writer = new FileWriter(userLogfile, true);
            try {
                writer.append(content);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write content in user log file " + userLogfile, e);
        }
    }

    protected <E extends TopiaEntity> Map<String, String> sortAndDecorate(Collection<E> beans) {
        Map result = this.sortAndDecorate(beans, null);
        return result;
    }

    protected <E extends TopiaEntity> Map<String, String> sortAndDecorate(Collection<E> beans, String context) {
        Map result = this.getDecoratorService().sortAndDecorate(this.getLocale(), beans, context);
        return result;
    }

    protected <E extends Idable> Map<String, String> sortAndDecorateIdAbles(Collection<E> beans) {
        Map result = this.sortAndDecorateIdAbles(beans, null);
        return result;
    }

    protected <E extends Idable> Map<String, String> sortAndDecorateIdAbles(Collection<E> beans, String context) {
        Map result = this.getDecoratorService().sortAndDecorateIdAbles(this.getLocale(), beans, context);
        return result;
    }

    protected <E> List<E> sortToList(Collection<E> beans) {
        List list = this.sortToList(beans, null);
        return list;
    }

    protected <E> List<E> sortToList(Collection<E> beans, String context) {
        List list = this.getDecoratorService().sortToList(this.getLocale(), beans, context);
        return list;
    }

    protected Map<String, String> createTimeSteps() {
        LinkedHashMap timeSteps = Maps.newLinkedHashMap();
        for (int i = 1; i < 13; ++i) {
            timeSteps.put("" + i, "" + i);
        }
        return timeSteps;
    }

    protected SimpleDateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return this.dateFormat;
    }

    protected SimpleDateFormat getMonthFormat() {
        if (this.monthFormat == null) {
            this.monthFormat = new SimpleDateFormat("mm-yyyy");
        }
        return this.monthFormat;
    }

    protected static ActionContext getActionContext() {
        return ActionContext.getContext();
    }

    protected TripListModel loadTripListModel(TripDAO tripDAO) throws TopiaException {
        long t0 = TimeLog.getTime();
        if (log.isInfoEnabled()) {
            log.info((Object)"Loading tripListModel...");
        }
        TripListModel result = new TripListModel();
        Multimap allByOcean = tripDAO.findAllIdsByOcean();
        result.setTripIdsByOcean(allByOcean);
        this.getT3Session().setTripListModel(result);
        List<OceanImpl> allOceans = Lists.newArrayList((Iterable)allByOcean.keySet());
        if (allOceans.contains(null)) {
            OceanImpl nullOcean = new OceanImpl();
            nullOcean.setLibelle(this._("t3.common.nullOcean", new Object[0]));
            nullOcean.setTopiaId("null");
            if (log.isInfoEnabled()) {
                log.info((Object)("Add a nullOcean : " + nullOcean.getLibelle() + " for " + allByOcean.get(null).size() + " trip(s)."));
            }
            allOceans.remove(null);
            allOceans.add(nullOcean);
            Collection ids = allByOcean.get(null);
            allByOcean.putAll((Object)nullOcean, (Iterable)ids);
            allByOcean.removeAll(null);
        }
        TIME_LOG.log(t0, "loadTripListModel for " + result.getNbTrips() + " trips.");
        allOceans = this.sortToList((Collection)allOceans);
        result.setOceans((List)allOceans);
        this.getT3Session().setTripListModel(result);
        return result;
    }
}

