/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.entities.user.T3UserImpl;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import fr.ird.t3.web.actions.admin.EditActionEnum;
import fr.ird.t3.web.actions.admin.UserAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAction
extends T3BaseTransactionAction
implements Preparable {
    protected static final Log log = LogFactory.getLog(UserAction.class);
    private static final long serialVersionUID = 1L;
    public static final String BACK_TO_LIST = "backToList";
    protected T3User user;
    protected String userEditAction;

    public String getUserEditAction() {
        return this.userEditAction;
    }

    public void setUserEditAction(String userEditAction) {
        this.userEditAction = userEditAction;
    }

    public void prepare() throws Exception {
        String userId = this.getUser().getTopiaId();
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            this.user = this.getUserService().getUserById(userId);
        }
    }

    public String doCreate() throws Exception {
        T3User t3User = this.getUser();
        String userLogin = t3User.getLogin();
        if (log.isInfoEnabled()) {
            log.info((Object)("will create user  " + userLogin));
        }
        this.getUserService().createUser(t3User);
        return BACK_TO_LIST;
    }

    public String doUpdate() throws Exception {
        T3User t3User = this.getUser();
        if (log.isInfoEnabled()) {
            log.info((Object)("will update user  " + t3User.getLogin()));
        }
        this.getUserService().updateUser(t3User);
        return "success";
    }

    public String doDelete() throws Exception {
        T3User t3User = this.getUser();
        if (log.isInfoEnabled()) {
            log.info((Object)("will delete user " + t3User.getLogin()));
        }
        this.getUserService().deleteUser(t3User.getTopiaId());
        return BACK_TO_LIST;
    }

    public void validate() {
        EditActionEnum action = this.getEditActionEnum();
        log.info((Object)("Edit action : " + action));
        if (action == null) {
            return;
        }
        T3User t3User = this.getUser();
        String userLogin = t3User.getLogin();
        switch (1.$SwitchMap$fr$ird$t3$web$actions$admin$EditActionEnum[action.ordinal()]) {
            case 1: {
                if (StringUtils.isEmpty((CharSequence)userLogin)) {
                    this.addFieldError("user.login", this._("t3.error.required.login", new Object[0]));
                } else {
                    T3User login;
                    try {
                        login = this.getUserService().getUserByLogin(userLogin);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not obtain user " + userLogin, e);
                    }
                    if (login != null) {
                        this.addFieldError("user.login", this._("t3.error.login.already.used", new Object[0]));
                    }
                }
                String userPassword = t3User.getPassword();
                if (!StringUtils.isEmpty((CharSequence)userPassword)) break;
                this.addFieldError("user.password", this._("t3.error.required.password", new Object[0]));
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public T3User getUser() {
        if (this.user == null) {
            this.user = new T3UserImpl();
        }
        return this.user;
    }

    protected EditActionEnum getEditActionEnum() {
        if (this.userEditAction == null) {
            return null;
        }
        return EditActionEnum.valueOf((String)this.userEditAction.toUpperCase());
    }
}

