<%--
  #%L
  T3 :: Web
  
  $Id: level1Configuration.jsp 687 2012-02-07 21:34:47Z chemit $
  $HeadURL: https://svn.mpl.ird.fr/osiris/t3/tags/t3-1.1.1/t3-web/src/main/webapp/WEB-INF/jsp/data/level1/level1Configuration.jsp $
  %%
  Copyright (C) 2010 - 2011 IRD, Codelutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/monthpicker.js' />"></script>
<style type="text/css">
  .ui-datepicker-calendar {
    display: none;
  }
</style>
<title><s:text name="t3.label.data.level1.configuration"/></title>

<h2><s:text name="t3.label.data.level1.configuration"/></h2>

<s:form method="post" validate="true" namespace="/level1">

  <fieldset>

    <legend>
      <s:text name="t3.label.configure"/>
    </legend>

      <%-- selected sample quality --%>
    <s:checkboxlist key="configuration.sampleQualityIds"
                    list="sampleQualities"
                    label='%{getText("t3.common.sampleQuality")}'
                    required="true" template="mycheckboxlist"/>

      <%-- selected sample type --%>
    <s:checkboxlist key="configuration.sampleTypeIds"
                    label='%{getText("t3.common.sampleType")}'
                    list="sampleTypes"
                    required="true" template="mycheckboxlist"/>

      <%-- selected fleet country --%>
    <s:checkboxlist key="configuration.fleetIds"
                    label='%{getText("t3.common.fleetCountry")}'
                    list="fleets"
                    required="true" template="mycheckboxlist"/>

      <%-- selected ocean --%>
    <s:select key="configuration.oceanId" list="oceans"
              label='%{getText("t3.common.ocean")}' required="true"/>

      <%-- begin date --%>
    <sj:datepicker key="configuration.beginDate" required="true"
                   label='%{getText("t3.common.beginDate")}'
                   appendText=" (mm-yyyy)"/>

      <%-- end date --%>
    <sj:datepicker key="configuration.endDate" required="true"
                   label='%{getText("t3.common.endDate")}'
                   appendText=" (mm-yyyy)"/>

      <%-- selected matching trip count --%>
    <s:label key="matchingTripCount"
             label='%{getText("t3.level1.matching.trip.count")}'
             required="true"/>

      <%-- selected matching sample count --%>
    <s:label key="matchingSampleCount"
             label='%{getText("t3.level1.matching.sample.count")}'
             required="true"/>

  </fieldset>
  <br/>
  <s:if test="configurationInSession">

    <%--Can remove configuration--%>
    <s:submit action="removeLevel1Configuration"
              key="t3.action.remove.configuration"
              align="right"/>
  </s:if>

  <%--validate + save configuration--%>
  <s:submit action="validateLevel1Configuration"
            key="t3.action.save.configuration"
            align="right"/>

</s:form>

<s:if test="confirm && configurationInSession">
  <ul class="floatLeft">
    <li>

      <s:a action="configureExtrapolateSampleCountedAndMeasured"
           namespace="/level1">
        <s:text
          name="t3.menu.treatment.level1.extrapolateSampleMeasuredAndCounted"/>
      </s:a>
    </li>
  </ul>
</s:if>

<script type="text/javascript">

  jQuery(document).ready(function () {

    $.prepareMonthPickers(
      {
        minDateAsMonth:'<s:property value="configuration.minDate"/>',
        maxDateAsMonth:'<s:property value="configuration.maxDate"/>'
      });

  });
</script>
