/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Maps;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TripListAction
extends T3BaseTransactionAction {
    protected static final Log log = LogFactory.getLog(TripListAction.class);
    private static final long serialVersionUID = 1L;
    @InjectFromDAO(entityType=Trip.class, method="findAllYearsUsedInTrip")
    protected List<Integer> allYears;
    @InjectFromDAO(entityType=Ocean.class, method="findAllUsedInActivity")
    protected List<Ocean> allOceans;
    @InjectFromDAO(entityType=Country.class, method="findAllFleetUsedInTrip")
    protected List<Country> allFleets;
    @InjectFromDAO(entityType=Vessel.class, method="findAllUsedInTrip")
    protected List<Vessel> allVessels;
    @InjectFromDAO(entityType=Trip.class, method="count")
    protected long nbTrips;
    protected Map<String, String> years;
    protected Map<String, String> oceans;
    protected Map<String, String> fleets;
    protected Map<String, String> vessels;

    public Map<String, String> getYears() {
        return this.years;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public long getNbTrips() {
        return this.nbTrips;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectFromDAO.class});
        this.years = Maps.newLinkedHashMap();
        for (Integer year : this.allYears) {
            this.years.put(year + "", year + "");
        }
        this.oceans = this.sortAndDecorate((Collection)this.allOceans);
        this.fleets = this.sortAndDecorate((Collection)this.allFleets);
        this.vessels = this.sortAndDecorate((Collection)this.allVessels);
        return super.input();
    }
}

