/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import fr.ird.t3.T3ConfigurationHelper;
import fr.ird.t3.T3ServiceFactory;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.entities.user.T3User;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class T3Session {
    private static final Log log = LogFactory.getLog(T3Session.class);
    public static final String SESSION_PARAMETER_T3_SESSION = "t3Session";
    public static final String PROPERTY_ACTION_CONTEXT = "actionContext";
    protected static final String PROPERTY_T3_SERVICE_FACTORY = "t3ServiceFactory";
    protected static final String PROPERTY_T3_USER = "t3User";
    protected static final String PROPERTY_T3_DATABASE_URL = "t3DatabaseUrl";
    protected static final String PROPERTY_ACTION_CONFIGURATION = "actionConfiguration";
    protected static final String PROPERTY_START_DATE = "startDate";
    protected static final String PROPERTY_USER_LOG_FILE = "userLogFile";
    protected static final String FILE_LOG_PATTERN = "%1$s-%2$td_%2$tm_%2$tY.log";
    protected Map<String, Object> store = new TreeMap();

    public static T3Session getT3Session() {
        Map session = ActionContext.getContext().getSession();
        T3Session t3Session = (T3Session)session.get("t3Session");
        if (t3Session == null) {
            t3Session = new T3Session();
            t3Session.setServiceFactory(T3ServiceFactory.newInstance());
            session.put("t3Session", t3Session);
        }
        return t3Session;
    }

    public static boolean isUserInSession() {
        T3Session session = T3Session.getT3Session();
        boolean result = session.getT3User() != null;
        return result;
    }

    public static boolean isT3DatabaseSelected() {
        T3Session session = T3Session.getT3Session();
        boolean result = session.getT3DatabaseUrl() != null;
        return result;
    }

    public T3ServiceFactory getServiceFactory() {
        return (T3ServiceFactory)this.get("t3ServiceFactory", T3ServiceFactory.class);
    }

    public void setServiceFactory(T3ServiceFactory serviceFactory) {
        this.set("t3ServiceFactory", (Object)serviceFactory);
    }

    public T3User getT3User() {
        return (T3User)this.get("t3User", T3User.class);
    }

    public void setT3User(T3User t3User) {
        this.set("t3User", (Object)t3User);
    }

    public String getT3DatabaseUrl() {
        return (String)this.get("t3DatabaseUrl", String.class);
    }

    public void setT3DatabaseUrl(String t3DatabaseUrl) {
        this.set("t3DatabaseUrl", (Object)t3DatabaseUrl);
    }

    public <C> C getActionConfiguration(Class<C> configurationClass) {
        String key = this.getActionConfigurationKey(configurationClass);
        return (C)this.get(key, configurationClass);
    }

    public <C> void setActionConfiguration(C actionConfiguration) {
        Preconditions.checkNotNull(actionConfiguration, (Object)"action configuration can not be null");
        String key = this.getActionConfigurationKey(actionConfiguration.getClass());
        this.set(key, actionConfiguration);
    }

    public <C> C removeActionConfiguration(Class<C> configurationClass) {
        String key = this.getActionConfigurationKey(configurationClass);
        Object remove = this.remove(key);
        return (C)remove;
    }

    public T3ActionContext<?> getActionContext() {
        return (T3ActionContext)this.get("actionContext", T3ActionContext.class);
    }

    public void setActionContext(T3ActionContext<?> actionContext) {
        this.set("actionContext", actionContext);
    }

    public void removeActionContext() {
        if (this.getActionContext() != null) {
            this.remove("actionContext");
        }
    }

    public Date getStartDate() {
        return (Date)this.get("startDate", Date.class);
    }

    public void setStartDate(Date startDate) {
        this.set("startDate", (Object)startDate);
    }

    public File getUserLogFile() {
        File result = (File)this.get("userLogFile", File.class);
        if (result == null) {
            ApplicationConfig configuration = T3ServiceFactory.getConfiguration();
            File userLogDirectory = T3ConfigurationHelper.getUserLogDirectory((ApplicationConfig)configuration);
            String filename = String.format("%1$s-%2$td_%2$tm_%2$tY.log", this.getT3User().getLogin(), this.getStartDate());
            result = new File(userLogDirectory, filename);
            if (log.isInfoEnabled()) {
                log.info((Object)("User log file " + result.getAbsolutePath()));
            }
            this.set("userLogFile", (Object)result);
        }
        return result;
    }

    public Object remove(String key) {
        Object remove = this.store.remove(key);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from user session data [" + key + "] = " + remove));
        }
        return remove;
    }

    public boolean contains(String key) {
        boolean result = this.store.containsKey(key);
        return result;
    }

    protected T3Session() {
    }

    protected <T> T get(String key, Class<T> type) {
        Object o = this.store.get(key);
        if (o != null && !type.isInstance(o)) {
            throw new ClassCastException("parameter " + key + " should be of type " + type.getName() + " but was " + o.getClass().getName());
        }
        return (T)o;
    }

    protected <C> String getActionConfigurationKey(Class<C> configurationClass) {
        return "actionConfiguration#" + configurationClass.getSimpleName();
    }

    protected void set(String key, Object value) {
        this.store.put(key, value);
        if (log.isInfoEnabled()) {
            log.info((Object)("Set in user session data [" + key + "] = " + value));
        }
    }
}

