<%--
  #%L
  T3 :: Web
  
  $Id: tripList.jsp 638 2011-10-28 18:50:35Z chemit $
  $HeadURL: https://svn.mpl.ird.fr/osiris/t3/tags/t3-1.0.2/t3-web/src/main/webapp/WEB-INF/jsp/admin/tripList.jsp $
  %%
  Copyright (C) 2010 - 2011 IRD, Codelutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<script type="text/javascript" src="<s:url value='/js/gridHelper.js' />"></script>
<title><s:text name="t3.label.admin.user.list"/></title>
<s:set var="userIsAdmin" value="%{#session.t3Session.t3User.admin}"/>
<s:url id="loadUrl" action="getTrips" namespace="/json" escapeAmp="false"/>

<s:url id="showUrl" action="tripDetail" namespace="/trip" escapeAmp="false"/>

<script type="text/javascript">

  var gridTitle = "<s:text name='t3.common.trips'/>";
  var nbMax = "<s:property value='nbTrips'/>";
  jQuery(document).ready(function () {
    var confirmTripDelete = $('#confirmTripDelete');
    confirmTripDelete.hide();
    var tripDetail = $('#tripDetail');
    tripDetail.hide();
    $.addRowSelectTopic('trips');
    $.addClearSelectTopic('trips');
    $.addMultiRowTopic('trips', 'Show', tripDetail, "tripIds");
    $.addMultiRowTopic('trips', 'DeleteTrips', confirmTripDelete, "tripIds");

    $.subscribe('resetFilter', function(event) {
      // reselect all
      $('#filterZone :checkbox').attr('checked', true);
      // re-apply filter
      $('#applyFilter').click();
    });

    $.subscribe('applyFilter', function(event) {
      var params = {};
      $.serializeCheckboxs('years', params);
      $.serializeCheckboxs('oceanIds', params);
      $.serializeCheckboxs('fleetIds', params);
      $.serializeCheckboxs('flagIds', params);
      $.serializeCheckboxs('vesselIds', params);
      var url = $.prepareUrl('${loadUrl}', params);
      $('#trips')[0].p.url = url;
      $('#refresh_trips').click();
    });

    $.subscribe('trips-completed', function(event) {

      $('[class="ui-jqgrid-title"]').text(gridTitle + " (" + $('#trips')[0].p.records + " / " + nbMax + ")");
    });
  });
</script>

<h2><s:text name="t3.label.admin.trip.list"/></h2>

<fieldset id='filterZone'>
  <legend>
    <s:text name="t3.label.tripFilter"/>
  </legend>
  <table class="fontsize11">
      <tr>
        <th><s:text name="t3.common.year"/></th>
        <th><s:text name="t3.common.ocean"/></th>
        <th><s:text name="t3.common.fleetCountry"/></th>
        <th><s:text name="t3.common.flagCountry"/></th>
        <th><s:text name="t3.common.vessel"/></th>
      </tr>
      <tr>
        <td class='verticalAlignTop'>
          <s:checkboxlist key="years" list="years" template="mycheckboxlist"
                          label='' labelSeparator=""/>
        </td>
        <td class='verticalAlignTop'>
          <s:checkboxlist name="oceanIds" value="oceans" list="oceans"
                          label='' labelSeparator=""
                          template="mycheckboxlist"/>
        </td>
        <td class='verticalAlignTop'>
          <s:checkboxlist name="fleetIds" value="fleets" list="fleets"
                          label='' labelSeparator=""
                          template="mycheckboxlist"/>
        </td>
        <td class='verticalAlignTop'>
          <s:checkboxlist name="flagIds" value="flags" list="flags"
                          label='' labelSeparator=""
                          template="mycheckboxlist"/>
        </td>
        <td class='verticalAlignTop'>
          <s:checkboxlist name="vesselIds" value='vessels' list="vessels"
                          label='' labelSeparator=""
                          template="mycheckboxlist"/>
        </td>
      </tr>
    </table>
  <br/>

  <div class="cleanBoth floatRight">
    <sj:submit onClickTopics="resetFilter" key="t3.action.resetFilter"/>
    <sj:submit id='applyFilter' onClickTopics="applyFilter"
               key="t3.action.applyFilter"/>
  </div>

</fieldset>
<br/>

<s:set id="deleteKey" value='%{getText("t3.action.deleteTrips")}'/>
<s:set id="detailKey" value='%{getText("t3.action.showDetails")}'/>

<s:form method="post" validate="false" namespace="/trip">
  <sjg:grid id="trips" caption="%{getText('t3.common.trips')}"
            dataType="json" href="%{loadUrl}" gridModel="trips"
            pager="true" pagerButtons="false" pagerInput="false"
            navigator="true" autowidth="true" rownumbers="false"
            rowNum="%{nbTrips}"
            onBeforeTopics="trips-before"
            onSelectRowTopics='trips-rowSelect'
            onCompleteTopics="trips-completed,trips-cleanSelect"
            navigatorEdit="false"
            navigatorDelete="false"
            navigatorSearch="false"
            navigatorRefresh="true"
            navigatorAdd="false"
            resizable="true"
            height="500"
            multiselect="true"
            navigatorExtraButtons="{
                show: { title : '%{detailKey}', icon: 'ui-icon-pencil', topic: 'trips-rowShow' },
                deleteTrips : { title : '%{deleteKey}', icon: 'ui-icon-trash', topic: 'trips-rowDeleteTrips' }
        }">
    <sjg:gridColumn name="id" title="id" hidden="true"/>
    <sjg:gridColumn name="vessel.libelle" sortable="false"
                    title='%{getText("t3.common.vessel")}'/>

    <sjg:gridColumn name="vessel.fleetCountry.libelle" sortable="false"
                    title='%{getText("t3.common.fleetCountry")}'/>

    <sjg:gridColumn name="vessel.flagCountry.libelle" sortable="false"
                    title='%{getText("t3.common.flagCountry")}'/>

    <sjg:gridColumn name="departureDate" formatter="date" sortable="false"
                    title='%{getText("t3.common.departureDate")}'/>

    <sjg:gridColumn name="landingDate" formatter="date" sortable="false"
                    title='%{getText("t3.common.landingDate")}'/>

  </sjg:grid>
  <s:submit id='confirmTripDelete' action="confirmTripDelete"/>
  <s:submit id='tripDetail' action="tripDetail"/>

</s:form>

