/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import winstone.jndi.ContainerJNDIManager;

public class WinstoneBindingEnumeration
implements NamingEnumeration {
    private Enumeration nameEnumeration;
    private Hashtable bindings;
    private Hashtable contextEnvironment;
    private Context context;

    public WinstoneBindingEnumeration(Hashtable bindings, Hashtable environment, Context context) {
        Object[] keys = bindings.keySet().toArray();
        Arrays.sort(keys);
        Vector<Object> nameList = new Vector<Object>(Arrays.asList(keys));
        this.nameEnumeration = nameList.elements();
        this.bindings = (Hashtable)bindings.clone();
        this.context = context;
        this.contextEnvironment = environment;
    }

    public Object next() throws NamingException {
        if (this.nameEnumeration == null) {
            throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneBindingEnumeration.AlreadyClosed"));
        }
        String name = (String)this.nameEnumeration.nextElement();
        Object value = this.bindings.get(name);
        try {
            value = NamingManager.getObjectInstance(value, new CompositeName().add(name), this.context, this.contextEnvironment);
        }
        catch (Throwable err) {
            NamingException errNaming = new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneBindingEnumeration.FailedToGetInstance"));
            errNaming.setRootCause(err);
            throw errNaming;
        }
        return new Binding(name, value);
    }

    public boolean hasMore() throws NamingException {
        if (this.nameEnumeration == null) {
            throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneBindingEnumeration.AlreadyClosed"));
        }
        return this.nameEnumeration.hasMoreElements();
    }

    public void close() throws NamingException {
        this.nameEnumeration = null;
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException err) {
            return false;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException err) {
            return null;
        }
    }
}

