/*
 * Decompiled with CFR 0.152.
 */
package winstone.ajp13;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import winstone.HostGroup;
import winstone.Launcher;
import winstone.Listener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.RequestHandlerThread;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;
import winstone.WinstoneInputStream;
import winstone.WinstoneOutputStream;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneResponse;
import winstone.ajp13.Ajp13IncomingPacket;
import winstone.ajp13.Ajp13OutputStream;

public class Ajp13Listener
implements Listener,
Runnable {
    public static final WinstoneResourceBundle AJP_RESOURCES = new WinstoneResourceBundle("winstone.ajp13.LocalStrings");
    private static final int LISTENER_TIMEOUT = 5000;
    private static final int DEFAULT_PORT = 8009;
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int BACKLOG_COUNT = 1000;
    private static final int KEEP_ALIVE_TIMEOUT = -1;
    private static final String TEMPORARY_URL_STASH = "winstone.ajp13.TemporaryURLAttribute";
    private HostGroup hostGroup;
    private ObjectPool objectPool;
    private int listenPort;
    private boolean interrupted;
    private String listenAddress;

    public Ajp13Listener(Map args, ObjectPool objectPool, HostGroup hostGroup) {
        this.hostGroup = hostGroup;
        this.objectPool = objectPool;
        this.listenPort = Integer.parseInt(WebAppConfiguration.stringArg(args, "ajp13Port", "8009"));
        this.listenAddress = WebAppConfiguration.stringArg(args, "ajp13ListenAddress", null);
    }

    public boolean start() {
        if (this.listenPort < 0) {
            return false;
        }
        this.interrupted = false;
        Thread thread = new Thread((Runnable)this, Launcher.RESOURCES.getString("Listener.ThreadName", new String[]{"ajp13", "" + this.listenPort}));
        thread.setDaemon(true);
        thread.start();
        return true;
    }

    public void run() {
        try {
            ServerSocket ss = this.listenAddress == null ? new ServerSocket(this.listenPort, 1000) : new ServerSocket(this.listenPort, 1000, InetAddress.getByName(this.listenAddress));
            ss.setSoTimeout(5000);
            Logger.log(Logger.INFO, AJP_RESOURCES, "Ajp13Listener.StartupOK", this.listenPort + "");
            while (!this.interrupted) {
                Socket s = null;
                try {
                    s = ss.accept();
                }
                catch (InterruptedIOException err) {
                    s = null;
                }
                if (s == null) continue;
                this.objectPool.handleRequest(s, this);
            }
            ss.close();
            Logger.log(Logger.INFO, AJP_RESOURCES, "Ajp13Listener.ShutdownOK");
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, AJP_RESOURCES, "Ajp13Listener.ShutdownError", err);
        }
    }

    public void destroy() {
        this.interrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateRequestResponse(Socket socket, InputStream inSocket, OutputStream outSocket, RequestHandlerThread handler, boolean iAmFirst) throws SocketException, IOException {
        WinstoneRequest req = this.objectPool.getRequestFromPool();
        WinstoneResponse rsp = this.objectPool.getResponseFromPool();
        rsp.setRequest(req);
        req.setHostGroup(this.hostGroup);
        if (!iAmFirst) {
            // empty if block
        }
        socket.setSoTimeout(60000);
        Ajp13IncomingPacket headers = null;
        try {
            headers = new Ajp13IncomingPacket(inSocket, handler);
        }
        catch (InterruptedIOException err) {
            if (iAmFirst) {
                throw err;
            }
            this.deallocateRequestResponse(handler, req, rsp, null, null);
            return;
        }
        finally {
            try {
                socket.setSoTimeout(60000);
            }
            catch (Throwable err) {}
        }
        if (headers.getPacketLength() > 0) {
            headers.parsePacket("8859_1");
            this.parseSocketInfo(headers, req);
            req.parseHeaders(Arrays.asList(headers.getHeaders()));
            String servletURI = this.parseURILine(headers, req, rsp);
            req.setAttribute(TEMPORARY_URL_STASH, servletURI);
            WinstoneInputStream inData = null;
            int contentLength = req.getContentLength();
            if (contentLength > 0) {
                byte[] bodyContent = new byte[contentLength];
                int position = 0;
                while (position < contentLength) {
                    outSocket.write(this.getBodyRequestPacket(Math.min(contentLength - position, 8184)));
                    position = this.getBodyResponsePacket(inSocket, bodyContent, position);
                    Logger.log(Logger.FULL_DEBUG, AJP_RESOURCES, "Ajp13Listener.ReadBodyProgress", new String[]{"" + position, "" + contentLength});
                }
                inData = new WinstoneInputStream(bodyContent);
                inData.setContentLength(contentLength);
            } else {
                inData = new WinstoneInputStream(new byte[0]);
            }
            req.setInputStream(inData);
            Ajp13OutputStream outData = new Ajp13OutputStream(socket.getOutputStream(), "8859_1");
            outData.setResponse(rsp);
            rsp.setOutputStream(outData);
            handler.setRequest(req);
            handler.setResponse(rsp);
            handler.setInStream(inData);
            handler.setOutStream(outData);
        }
    }

    public void deallocateRequestResponse(RequestHandlerThread handler, WinstoneRequest req, WinstoneResponse rsp, WinstoneInputStream inData, WinstoneOutputStream outData) throws IOException {
        handler.setInStream(null);
        handler.setOutStream(null);
        handler.setRequest(null);
        handler.setResponse(null);
        if (req != null) {
            this.objectPool.releaseRequestToPool(req);
        }
        if (rsp != null) {
            this.objectPool.releaseResponseToPool(rsp);
        }
    }

    public String parseURI(RequestHandlerThread handler, WinstoneRequest req, WinstoneResponse rsp, WinstoneInputStream inData, Socket socket, boolean iAmFirst) throws IOException {
        String uri = (String)req.getAttribute(TEMPORARY_URL_STASH);
        req.removeAttribute(TEMPORARY_URL_STASH);
        return uri;
    }

    public void releaseSocket(Socket socket, InputStream inSocket, OutputStream outSocket) throws IOException {
        inSocket.close();
        outSocket.close();
        socket.close();
    }

    private void parseSocketInfo(Ajp13IncomingPacket headers, WinstoneRequest req) {
        req.setServerPort(headers.getServerPort());
        req.setRemoteIP(headers.getRemoteAddress());
        req.setServerName(headers.getServerName());
        req.setLocalPort(headers.getServerPort());
        req.setLocalAddr(headers.getServerName());
        req.setRemoteIP(headers.getRemoteAddress());
        if (headers.getRemoteHost() != null && !headers.getRemoteHost().equals("")) {
            req.setRemoteName(headers.getRemoteHost());
        } else {
            req.setRemoteName(headers.getRemoteAddress());
        }
        req.setScheme(headers.isSSL() ? "https" : "http");
        req.setIsSecure(headers.isSSL());
    }

    private String parseURILine(Ajp13IncomingPacket headers, WinstoneRequest req, WinstoneResponse rsp) throws UnsupportedEncodingException {
        req.setMethod(headers.getMethod());
        req.setProtocol(headers.getProtocol());
        rsp.setProtocol(headers.getProtocol());
        rsp.extractRequestKeepAliveHeader(req);
        Iterator i = headers.getAttributes().keySet().iterator();
        while (i.hasNext()) {
            String attName = (String)i.next();
            if (attName.equals("query_string")) {
                String qs = (String)headers.getAttributes().get("query_string");
                req.setQueryString(qs);
                continue;
            }
            if (attName.equals("ssl_cert")) {
                String certValue = (String)headers.getAttributes().get("ssl_cert");
                ByteArrayInputStream certStream = new ByteArrayInputStream(certValue.getBytes("8859_1"));
                X509Certificate[] certificateArray = new X509Certificate[1];
                try {
                    certificateArray[0] = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certStream);
                }
                catch (CertificateException err) {
                    Logger.log(Logger.DEBUG, AJP_RESOURCES, "Ajp13Listener.SkippingCert", certValue);
                }
                req.setAttribute("javax.servlet.request.X509Certificate", certificateArray);
                req.setIsSecure(true);
                continue;
            }
            if (attName.equals("ssl_cipher")) {
                String cipher = (String)headers.getAttributes().get("ssl_cipher");
                req.setAttribute("javax.servlet.request.cipher_suite", cipher);
                req.setAttribute("javax.servlet.request.key_size", this.getKeySize(cipher));
                req.setIsSecure(true);
                continue;
            }
            if (attName.equals("ssl_session")) {
                req.setAttribute("javax.servlet.request.ssl_session", headers.getAttributes().get("ssl_session"));
                req.setIsSecure(true);
                continue;
            }
            Logger.log(Logger.DEBUG, AJP_RESOURCES, "Ajp13Listener.UnknownAttribute", new String[]{attName, "" + headers.getAttributes().get(attName)});
        }
        return headers.getURI();
    }

    private Integer getKeySize(String cipherSuite) {
        if (cipherSuite.indexOf("_WITH_NULL_") != -1) {
            return new Integer(0);
        }
        if (cipherSuite.indexOf("_WITH_IDEA_CBC_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_RC2_CBC_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_128_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_DES40_CBC_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_DES_CBC_") != -1) {
            return new Integer(56);
        }
        if (cipherSuite.indexOf("_WITH_3DES_EDE_CBC_") != -1) {
            return new Integer(168);
        }
        return null;
    }

    public boolean processKeepAlive(WinstoneRequest request, WinstoneResponse response, InputStream inSocket) throws IOException, InterruptedException {
        return true;
    }

    private byte[] getBodyRequestPacket(int desiredPacketLength) {
        byte[] getBodyRequestPacket = new byte[]{65, 66, 0, 3, 6, 0, 0};
        Ajp13OutputStream.setIntBlock(desiredPacketLength, getBodyRequestPacket, 5);
        return getBodyRequestPacket;
    }

    private int getBodyResponsePacket(InputStream in, byte[] buffer, int offset) throws IOException {
        DataInputStream din = new DataInputStream(in);
        byte[] headerBuffer = new byte[4];
        din.readFully(headerBuffer);
        if (headerBuffer[0] != 18 || headerBuffer[1] != 52) {
            throw new WinstoneException(AJP_RESOURCES.getString("Ajp13Listener.InvalidHeader"));
        }
        int packetLength = ((headerBuffer[2] & 0xFF) << 8) + (headerBuffer[3] & 0xFF);
        if (packetLength == 0) {
            return offset;
        }
        byte[] bodyLengthBuffer = new byte[2];
        din.readFully(bodyLengthBuffer);
        int bodyLength = ((bodyLengthBuffer[0] & 0xFF) << 8) + (bodyLengthBuffer[1] & 0xFF);
        din.readFully(buffer, offset, bodyLength);
        return bodyLength + offset;
    }
}

