/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterManager<E extends SamplingFilter> {
    private static final Logger log = LoggerFactory.getLogger(FilterManager.class);
    protected ConnectedUser user;
    protected ServiceSampling serviceSampling;
    protected SamplingFilterValues possibleValuesForFilter;

    public FilterManager(ConnectedUser user, ServiceSampling serviceSampling) {
        this.serviceSampling = serviceSampling;
        this.user = user;
        this.resetFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceSampling.getPossibleValuesForFilter(this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public ConnectedUser getUser() {
        return this.user;
    }

    public abstract E getFilter();

    public abstract void resetFilter();

    protected abstract boolean isAvailableDataForFiltersOnly();

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }
}

