/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.FacadeRow;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.entity.DCF5Code;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.PeriodDates;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;

@RequiresAuthentication
@IncludeStylesheet(value={"context:css/sampling.css"})
public class SamplingPlan
extends AbstractFilteredPage {
    @Inject
    private Logger logger;
    @Inject
    private WaoManager manager;
    @Inject
    private Messages messages;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceReferential serviceReferential;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    private long nbTidesExpectedTime;
    private long nbTidesRealTime;
    private long totalTidesExpectedTime;
    private long totalTidesRealTime;
    @Persist
    private SamplingFilter filter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Form filtersForm;
    private boolean reset;
    @Persist
    private Boolean showFilters;
    @Persist
    @Property
    private Boolean fullView;
    private List<SampleRow> data;
    private List<Date> months;
    @Property
    private Date month;
    @Property
    private DCF5Code dcf5code;
    @Property
    private SampleRow row;
    @Property
    private String currentFacadeName;
    @Property
    private String currentSectorName;
    private static final StringUtil.ToString<FishingZone> FISHING_ZONE_TO_STRING_DISTRICT = new /* Unavailable Anonymous Inner Class!! */;
    private Map<Date, Integer> totalExpectedForMonths;
    private Map<Date, Integer> totalRealForMonths;
    private Integer highTotalExpected;
    private Integer highTotalReal;
    @Property
    private int rowIndex;

    void setupRender() {
        if (this.isFiltersVisible()) {
            this.initSelectFilters(true, false, true);
        }
        if (this.fullView == null) {
            this.fullView = this.user.isAdmin();
        }
        this.initCompanyFilter();
    }

    StreamResponse onActionFromExportSamplingPlan() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public PeriodDates getPeriod() {
        return this.getFilter().getPeriod();
    }

    public SamplingFilter getFilter() throws WaoException {
        if (this.filter == null) {
            this.filter = new SamplingFilterImpl();
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)11);
            this.filter.setPeriod(period);
        }
        return this.filter;
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public boolean isFiltersVisible() {
        if (this.showFilters == null) {
            this.showFilters = false;
        }
        return BooleanUtils.isTrue((Boolean)this.showFilters);
    }

    Object onActionFromShowFilters() {
        this.showFilters = this.showFilters == false;
        this.initSelectFilters(true, false, true);
        if (this.isFiltersVisible()) {
            return this.filtersZone.getBody();
        }
        return this.filtersZone;
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    Object onSuccessFromFiltersForm() {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            PeriodDates period = this.getFilter().getPeriod();
            this.filter = null;
            this.getFilter().setPeriod(period);
        }
        return this;
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    void onActionFromChangeFilterEstimatedTides() {
        boolean oldValue = this.getFilter().getEstimatedTides();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Change estimatedTides in filter to : " + !oldValue);
        }
        this.getFilter().setEstimatedTides(!oldValue);
    }

    public List<SampleRow> getData() throws WaoException {
        if (this.data == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("sampleRows filter sent to service : " + this.getFilter().getSampleRows());
            }
            FacadeRow facade = this.serviceSampling.getSampleRowsOrderedByFishingZone(this.getFilter());
            this.data = facade.getValues();
        }
        return this.data;
    }

    public List<Date> getMonths() {
        if (this.months == null) {
            this.months = this.getPeriod().getMonths();
        }
        return this.months;
    }

    public boolean isFacadeChanged() {
        if (!this.row.getFacade().equals(this.currentFacadeName)) {
            this.currentFacadeName = this.row.getFacade();
            return true;
        }
        return false;
    }

    public boolean isSectorChanged() {
        if (!this.row.getSectors().equals(this.currentSectorName)) {
            this.currentSectorName = this.row.getSectors();
            return true;
        }
        return false;
    }

    public String getCompanyName() {
        return this.row.getCompany() != null ? this.row.getCompany().getName() : "";
    }

    public boolean isCurrentMonth() {
        String currentStr = this.getDateFormat().format(new Date());
        String monthStr = this.getDateFormat().format(this.month);
        return currentStr.equals(monthStr);
    }

    public Integer getNbTidesExpected() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = sampleMonth.getExpectedTidesValue();
        }
        return result;
    }

    public String getFishingZones() {
        return StringUtil.join((Iterable)this.row.getFishingZone(), (StringUtil.ToString)FISHING_ZONE_TO_STRING_DISTRICT, (String)", ", (boolean)false);
    }

    public Integer getNbTidesReal() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = this.getFilter().getEstimatedTides() ? sampleMonth.getEstimatedTidesValue() : sampleMonth.getRealTidesValue();
        }
        return result;
    }

    public boolean hasNbTidesReal() {
        Date current = new Date();
        boolean validMonth = this.month.before(current) || this.isCurrentMonth();
        return validMonth && this.getNbTidesReal() != null;
    }

    public boolean canDisplayTidesReal() {
        boolean result = this.hasNbTidesReal() && !this.user.isGuest();
        return result;
    }

    public String getTotalPercentage() {
        double result = 0.0;
        if (this.row.getTotalTidesExpected() > 0) {
            result = (double)this.row.getTotalTidesReal().intValue() / (double)this.row.getTotalTidesExpected().intValue();
        }
        return NumberFormat.getPercentInstance().format(result);
    }

    public NumberFormat getNumberFormat() {
        return NumberFormat.getNumberInstance();
    }

    protected void setTotalsForMonths() {
        Date keptMonth = this.month;
        this.totalExpectedForMonths = new HashMap();
        this.totalRealForMonths = new HashMap();
        this.highTotalExpected = 0;
        this.highTotalReal = 0;
        Iterator<Object> i$ = this.getMonths().iterator();
        while (i$.hasNext()) {
            Date date;
            this.month = date = (Date)i$.next();
            Integer totalExpected = 0;
            Integer totalReal = 0;
            Iterator i$2 = this.getData().iterator();
            while (i$2.hasNext()) {
                SampleRow row;
                this.row = row = (SampleRow)i$2.next();
                Integer expected = this.getNbTidesExpected();
                Integer real = this.getNbTidesReal();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("for month %s and row %s : expected = %s, real = %s", this.getDateFormat().format(date), row.getCode(), expected, real));
                }
                if (expected != null) {
                    totalExpected = totalExpected + expected;
                }
                if (real == null || !this.canDisplayTidesReal()) continue;
                totalReal = totalReal + real;
            }
            this.totalExpectedForMonths.put(date, totalExpected);
            this.totalRealForMonths.put(date, totalReal);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("totals for month %s : expected = %s, actual = %s", this.getDateFormat().format(date), totalExpected, totalReal));
            }
            this.highTotalExpected = this.highTotalExpected + totalExpected;
            this.highTotalReal = this.highTotalReal + totalReal;
        }
        if (this.logger.isDebugEnabled()) {
            for (Map.Entry entry : this.totalExpectedForMonths.entrySet()) {
                this.logger.debug(String.format("totals for month %s : expected = %s, actual = %s", this.getDateFormat().format((Date)entry.getKey()), entry.getValue(), this.totalRealForMonths.get(entry.getKey())));
            }
        }
        this.month = keptMonth;
    }

    public Integer getTotalExpectedForMonth() {
        if (this.totalExpectedForMonths == null) {
            this.setTotalsForMonths();
        }
        Integer total = (Integer)this.totalExpectedForMonths.get(this.month);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("total for month %s is %s", this.getDateFormat().format(this.month), total));
        }
        return total;
    }

    public Integer getTotalRealForMonth() {
        if (this.totalExpectedForMonths == null) {
            this.setTotalsForMonths();
        }
        return (Integer)this.totalRealForMonths.get(this.month);
    }

    public String getRatioForMonth() {
        String ratio = "";
        if (this.getTotalExpectedForMonth() > 0) {
            double percent = (double)this.getTotalRealForMonth().intValue() / (double)this.getTotalExpectedForMonth().intValue();
            ratio = NumberFormat.getPercentInstance().format(percent);
        }
        return ratio;
    }

    public Integer getHighTotalExpected() {
        if (this.highTotalExpected == null) {
            this.setTotalsForMonths();
        }
        return this.highTotalExpected;
    }

    public Integer getHighTotalReal() {
        if (this.highTotalReal == null) {
            this.setTotalsForMonths();
        }
        return this.highTotalReal;
    }

    public String getHighTotalRatio() {
        String ratio = "";
        if (this.getHighTotalExpected() > 0) {
            double percent = (double)this.getHighTotalReal().intValue() / (double)this.getHighTotalExpected().intValue();
            ratio = NumberFormat.getPercentInstance().format(percent);
        }
        return ratio;
    }

    public String getRowComment() {
        String comment = this.row.getComment();
        comment = comment.replace("\n", "<br />");
        return comment;
    }

    public int getNbColumnsForProfession() {
        int fixed = 5;
        if (this.fullView.booleanValue()) {
            fixed += 8;
        }
        return fixed;
    }

    public int getNbColumnsForMonths() {
        return this.getMonths().size() + 1;
    }

    public int getNbColumnsForOther() {
        return 4;
    }

    public int getNbColumnsTotal() {
        return this.getNbColumnsForProfession() + this.getNbColumnsForMonths() + this.getNbColumnsForOther();
    }

    public String getMainClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getParityClass() {
        return this.rowIndex % 2 == 0 ? "even" : "odd";
    }

    public String getActionsClass() {
        return this.fullView != false ? "width100" : "width50";
    }

    public String getRealTidesClass() {
        String result = "real-warning";
        if (this.getNbTidesReal() < this.getNbTidesExpected()) {
            result = result + "-inf";
        } else if (this.getNbTidesReal() > this.getNbTidesExpected()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getRealTidesClassForTotal() {
        String result = "real-warning";
        if (this.getTotalRealForMonth() < this.getTotalExpectedForMonth()) {
            result = result + "-inf";
        } else if (this.getTotalExpectedForMonth() > this.getTotalRealForMonth()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getMonthCurrentClass() {
        return this.isCurrentMonth() ? "selected" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public boolean canEditSampleRow() {
        return this.user.isAdmin() && !this.user.isReadOnly();
    }

    void onActionFromFilterPeriodDates(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.getPeriod().setFromDate(this.row.getPeriodBegin());
        this.getPeriod().setThruDate(this.row.getPeriodEnd());
    }

    void onActionFromDeleteSampleRow(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        try {
            this.serviceSampling.deleteSampleRow(this.row);
        }
        catch (WaoBusinessException eee) {
            String error = this.manager.getErrorMessage(eee, this.messages, this.logger);
            this.layout.addError(new String[]{error});
        }
    }

    public boolean isRowNotFinished() {
        return !this.row.isFinished(-1);
    }

    public boolean isRowModified() {
        return this.row.getTopiaVersion() > 1L;
    }

    static /* synthetic */ ConnectedUser access$000(SamplingPlan x0) {
        return x0.user;
    }

    static /* synthetic */ ServiceSampling access$100(SamplingPlan x0) {
        return x0.serviceSampling;
    }
}

