/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.entity.News;
import fr.ifremer.wao.service.ServiceNews;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@RequiresAuthentication
@IncludeStylesheet(value={"context:css/news.css"})
@IncludeJavaScriptLibrary(value={"context:js/news.js"})
public class Index {
    @Inject
    private ServiceNews serviceNews;
    @Inject
    private Logger log;
    @SessionState
    @Property
    private ConnectedUser user;
    @Persist
    private List<News> newsList;
    @Property
    private News news;
    private DateFormat dateFormat;
    @Persist(value="flash")
    private String editedId;
    @Property
    private int rowIndex;
    @Property
    @Inject
    @Path(value="context:js/FCKConf.js")
    private Asset2 fckconf;
    @Inject
    private RenderSupport renderSupport;
    private static final int NEWS_CONTENT_MAX_CHARS = 500;

    public void afterRender() {
        this.renderSupport.addScript("newsHider = new NewsHider();\nnewsHider.hideAllNewsDetails();");
    }

    @Log
    void setupRender() throws WaoException {
        if (this.editedId == null || !"NEW".equals(this.editedId)) {
            this.newsList = null;
            this.getNewsList();
        }
    }

    public List<News> getNewsList() throws WaoException {
        if (this.newsList == null) {
            this.newsList = this.serviceNews.getNews(this.user);
        }
        return this.newsList;
    }

    public boolean canEditNews() {
        if (this.user.isReadOnly()) {
            return false;
        }
        boolean result = false;
        if (this.news != null) {
            boolean adminEdit = this.news.isFromAdmin() && this.user.isAdmin();
            boolean companyEdit = !this.news.isFromAdmin() && this.user.isCoordinator();
            result = adminEdit || companyEdit;
        } else {
            result = this.user.isAdmin() || this.user.isCoordinator();
        }
        return result;
    }

    public String getHeaderStyle() {
        String result = "";
        if (!this.news.isFromAdmin()) {
            result = "company";
        }
        return result;
    }

    public boolean isEditionMode() {
        return this.isCreateMode() || this.news.getTopiaId().equals(this.editedId);
    }

    public boolean isCreateMode() {
        return this.news.getTopiaId() == null;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return this.dateFormat;
    }

    public boolean isMoreContentNeeded() {
        return this.news.getContent().length() > 500;
    }

    public String getNewsContent() {
        String result = this.news.getContent();
        if (this.isMoreContentNeeded()) {
            result = result.substring(0, 500);
        }
        return result;
    }

    public String getNewsMoreContent() {
        String content = this.news.getContent();
        String result = content.substring(500, content.length());
        return result;
    }

    void onActionFromAddNews() throws WaoException {
        this.news = this.serviceNews.getNewNews(this.user);
        ArrayList<News> list = new ArrayList<News>();
        list.add(this.news);
        list.addAll(this.getNewsList());
        this.newsList = list;
        this.editedId = "NEW";
    }

    void onActionFromEditNews(int rowIndex) throws WaoException {
        this.news = (News)this.getNewsList().get(rowIndex);
        this.editedId = this.news.getTopiaId();
    }

    void onActionFromDeleteNews(int rowIndex) throws WaoException {
        this.news = (News)this.getNewsList().get(rowIndex);
        this.serviceNews.saveNews(this.news, true);
    }

    void onActionFromCancelEdit() {
    }

    void onSelectedFromSaveNews(int rowIndex) throws WaoException {
        this.news = (News)this.getNewsList().get(rowIndex);
    }

    void onSuccessFromNewsForm() throws WaoException {
        if (this.canEditNews()) {
            this.serviceNews.saveNews(this.news, false);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.news.getContent());
            }
        }
    }
}

