/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Layout.java 554 2010-06-21 09:23:28Z fdesbois $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.4.1/wao-ui/src/main/java/fr/ifremer/wao/ui/components/Layout.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.pages.Index;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

import java.util.Calendar;

/**
 * Layout
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class Layout {

    @Inject
    private WaoManager manager;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String pageTitle;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String contentId;

    @InjectComponent
    private FeedBack contentFeedback;

    @Inject
    private Request request;

    @Inject
    private Logger logger;

    @Inject
    private Messages messages;

    @Inject
    private ServiceAuthentication serviceAuthentication;

    private boolean fatal = false;

    boolean afterRender() {
        // Check if fatal errors has been added to the layout
        // Reload the page if feedBack hasn't been reloaded yet to display
        // errors
        if (fatal && contentFeedback.hasErrors() &&
                !contentFeedback.hasBeeanReloaded()) {
            if (logger.isInfoEnabled()) {
                logger.info("[ FATAL ] Reload the page to display" +
                        " errors");
            }
            contentFeedback.reload();
            return false;
        }
        // Clear errors after page render
        contentFeedback.clearErrors();
        fatal = false;
        return true;
    }

    public int getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.YEAR);
    }

    public boolean isDevEnvironment() {
        return manager.isDevEnvironment();
    }

    /**
     * Test if the current user in session is a valid user.
     * Test topia id existence because ConnectedUser can be empty when session is lost
     *
     * @return true if the current user is a valide user (not empty).
     * @see fr.ifremer.wao.ui.services.AppModule#
     * contributeApplicationStateManager(MappedConfiguration)
     */
    public boolean isCurrentUserExists() {
        return serviceAuthentication.existConnectedUser();
    }

    public String getContextPath() {
        return request.getContextPath();
    }

    public String getVersion() {
        return WaoProperty.APP_VERSION.getValue();
    }
    
    public ConnectedUser getCurrentUser() {
        return serviceAuthentication.getConnectedUser();
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    public String getAdminClass() {
        return !isAdministrationHidden() ? " admin" : "";
    }

    public String getSamplingSelected() {
        return this.contentId.equals("so-sampling") ? "selected" : "";
    }

    public String getBoatsSelected() {
        return this.contentId.equals("so-boats") ? "selected" : "";
    }

    public String getContactsSelected() {
        return this.contentId.equals("so-contacts") ? "selected" : "";
    }

    public String getSynthesisSelected() {
        return this.contentId.equals("so-synthesis") ? "selected" : "";
    }

    public String getAdminSelected() {
        return this.contentId.equals("so-admin") ? "selected" : "";
    }

    public boolean isAdministrationHidden() {
        return !getCurrentUser().isAdmin() && !getCurrentUser().isCoordinator();
    }

    public String getAccessText() {
        String text = getCurrentUser().getRole().getLabel();
        if (getCurrentUser().isReadOnly()) {
            text += " lecture seule";
        }
        return text;
    }

    public boolean displayBody() {
        return !fatal;
    }

    /**
     * Add an info message to the layout.
     *
     * @param message of the info
     */
    public void addInfo(String message) {
        contentFeedback.addInfo(message);
    }

    /**
     * Add an error to the layout : display the body any way.
     *
     * @param message of the error
     */
    public void addError(String... message) {
        contentFeedback.addError(message);
    }

    /**
     * Add a fatal error to the layout : don't display the page body.
     *
     * @param message of the error
     */
    public void addFatal(String message) {
        contentFeedback.addError(message);
        fatal = true;
    }


    @Log
    Object onActionFromExit() {
        serviceAuthentication.setConnectedUser(null);
        request.getSession(false).invalidate();
        return Index.class;
    }
        
}
