/**
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package fr.ifremer.wao.ui.mixins;

import org.apache.commons.lang.ArrayUtils;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;

/**
 * ZoneUpdater.java
 *
 * From http://tinybits.blogspot.com/2009/05/update-zone-on-any-client-side-event.html by ingesol
 *
 * @author ingesol
 * @version $Revision: 355 $
 *
 * Last update: $Date: 2010-02-16 14:56:07 +0100 (mar., 16 févr. 2010) $
 * by : $Author: fdesbois $
 */
@IncludeJavaScriptLibrary("context:js/ZoneUpdater.js")
public class ZoneUpdater {

    public static final String PLACEHOLDER = "XXX";
    
    @Inject
    private ComponentResources resources;

    @Environmental
    private RenderSupport renderSupport;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    private String clientEvent;

    @Parameter(defaultPrefix = BindingConstants.LITERAL, required = true)
    private String event;

    @InjectContainer
    private ClientElement element;

    @Parameter
    private Object[] context;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    // To enable popups to fire events on this document, enter "document" here.
    private String listeningElement;

    @Parameter(defaultPrefix = BindingConstants.LITERAL, required = true)
    private String zone;

    protected Link createLink(Object[] context) {

        if (context == null) {
            context = new Object[]{PLACEHOLDER};
        } else {
            context = ArrayUtils.add(context, PLACEHOLDER); // To be replaced by javascript
        }

        return resources.createEventLink(event, context);

    }

    void afterRender() {
        String link = createLink(context).toAbsoluteURI();
        String elementId = element.getClientId();
        if (clientEvent == null) {
            clientEvent = event;
        }

        if (listeningElement == null) {
            listeningElement = "$('" + elementId + "')";
        }
        renderSupport.addScript("new ZoneUpdater('%s', %s, '%s', '%s', '%s', '%s')", elementId, listeningElement, clientEvent, link, zone, PLACEHOLDER);

    }
}
