/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ioc.Messages;
import org.slf4j.Logger;

/**
 * DataUtils
 *
 * Created: 3 déc. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class BusinessUtils {


    public static String getTooltipSampleRow(SampleRow row) {
        String result = "";
        DateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result += "<strong>Métier : </strong>" + profession.getCodeDCF5();
        if (!StringUtils.isEmpty(profession.getMeshSize())) {
            result+= " " + profession.getMeshSize();
        }
        if (!StringUtils.isEmpty(profession.getSize())) {
            result+= " " + profession.getSize();
        }
        if (!StringUtils.isEmpty(profession.getOther())) {
            result+= " " + profession.getOther();
        }
        result += " - " + profession.getLibelle();
        if (!StringUtils.isEmpty(profession.getSpecies())) {
            result += "<br /><strong>Espèces cibles : </strong>" + profession.getSpecies();
        }
        result += "<br /><strong>Programme : </strong>" + row.getProgramName();
        result += "<br /><strong>Période : </strong> du " + dateFormat.format(row.getPeriodBegin()) +
                " au " + dateFormat.format(row.getPeriodEnd());

        for (FishingZone zone : row.getFishingZone()) {
            result += "<br /><strong>Zone de pêche : </strong>" + zone.getCode();
        }

        return result;
    }

    public static String getTooltipBoat(Boat boat) {
        String result = "";
        result += "<strong>" + boat.getImmatriculation() + "</strong>";
        result += "<br /><strong>Quartier : </strong>" + boat.getDistrictCode();
        result += "<br /><strong>Longueur : </strong>" + boat.getBoatLength() + " m";
        result += "<br /><strong>Année de construction : </strong>" + boat.getBuildYear();
        return result;
    }

    public static String getDataSamplingTitle(SamplingFilter filter) {
        String result = "Données des marées";
        boolean filtered = false;
        if (filter.getCompany() != null) {
            //result += !filtered ? " : " : ", ";
            result += " :\nSociété " + filter.getCompany().getName();
            filtered = true;
        }
        if (StringUtils.isNotEmpty(filter.getProgramName())) {
            result += !filtered ? " : " : ", ";
            result += "\nProgramme " + filter.getProgramName();
            filtered = true;
        }
        if (filter.getSampleRow() != null) {
            Profession profession = filter.getSampleRow().getProfession();
            result += !filtered ? " : " : ", ";
            result += "\nMétier " + profession.getCode();
            result += StringUtils.isNotEmpty(profession.getLibelle()) ? " - " + profession.getLibelle() : "";
            result += StringUtils.isNotEmpty(profession.getSpecies()) ? "\nEspèces (" + profession.getSpecies() + ")" : "";
            result += "\nZones de pêche (";
            for (FishingZone zone : filter.getSampleRow().getFishingZone()) {
                result += zone.getDistrictCode() + " ";
            }
            result += ")";
            filtered = true;
        } else {
            if (filter.getFacadeName() != null) {
                result += !filtered ? " : " : ", ";
                result += "\nFaçade " + filter.getFacadeName();
                filtered = true;
            }
            if (filter.getSectorName() != null) {
                result += !filtered ? " : " : ", ";
                result += "\nZone " + filter.getSectorName();
                //filtered = true;
            }
        }
        return result;
    }

    public static String getContactStyle(Contact contact, boolean admin) {
        String result = "";
        boolean accepted = BooleanUtils.isTrue(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isTrue(contact.getValidationCompany()));

        ContactState state = contact.getContactState();
        if (BooleanUtils.isFalse(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isFalse(contact.getValidationCompany()))) {
            result = "refused";
        } else if (accepted && state.equals(ContactState.BOARDING_DONE)) {
            result = "accepted";
        } else if (accepted && state.isUnfinishedState()) {
            result = "unfinished";
        } else if (state.isFinalState()) {
            result = "even";
        } else {
            result = "odd";
        }
        return result;
    }

    public static String[] getErrorMessages(WaoException eee, Messages messages,
            Logger logger) {

        String[] results = null;
        String cause = null;
        if (eee.getCause() != null) {
            cause = eee.getCause().getClass().getSimpleName() +
                        " : " + eee.getCause().getMessage();
            results = new String[2];
            results[1] = cause;
        } else {
            results = new String[1];
        }


        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage() +
                    " _ args = " + eee.getArgs());
            if (cause != null) {
                logger.debug("ERROR caused by : " + cause);
            }
        }

        if (eee.getArgs() != null) {
            results[0] = messages.format(eee.getMessage(), eee.getArgs());
        } else {
            results[0] = messages.get(eee.getMessage());
        }
        return results;
    }

    public static String getErrorMessage(WaoBusinessException eee, Messages messages,
            Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage());
        }
        return eee.getMessage();
    }
}
