/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationResult;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericFormatImportCruiseResult
implements Serializable,
Iterable<GenericFormatImportOperationResult> {
    private static final long serialVersionUID = 1L;
    private final Map<String, GenericFormatImportOperationResult> fishingOperationResults;
    private final Cruise cruise;
    private final boolean override;
    private final String label;
    private int nbOperationsCreated;
    private int nbOperationsUpdated;
    private boolean withInvalidWeights;

    public GenericFormatImportCruiseResult(GenericFormatImportCruiseContext cruiseContext) {
        this.label = cruiseContext.getCruiseLabel();
        this.cruise = cruiseContext.getCruise();
        this.override = cruiseContext.getExistingCruiseData() != null;
        this.fishingOperationResults = new LinkedHashMap<String, GenericFormatImportOperationResult>();
        this.withInvalidWeights = false;
        for (GenericFormatImportOperationContext operationContext : cruiseContext.orderedFishingOperationContexts()) {
            GenericFormatImportOperationResult operationResult = new GenericFormatImportOperationResult(operationContext);
            this.fishingOperationResults.put(operationContext.getFishingOperation().getId(), operationResult);
            if (operationContext.isOverride()) {
                ++this.nbOperationsUpdated;
            } else {
                ++this.nbOperationsCreated;
            }
            if (!operationResult.isWithInvalidWeights()) continue;
            this.withInvalidWeights = true;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.cruise.getId();
    }

    public int getNbOperationsCreated() {
        return this.nbOperationsCreated;
    }

    public int getNbOperationsUpdated() {
        return this.nbOperationsUpdated;
    }

    public int getNbOperations() {
        return this.nbOperationsCreated + this.nbOperationsUpdated;
    }

    public boolean isWithInvalidWeights() {
        return this.withInvalidWeights;
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getVesselName() {
        Vessel vessel = this.cruise.getVessel();
        String result = vessel.getInternationalRegistrationCode();
        if (result == null) {
            result = vessel.getRegistrationCode();
        }
        return result;
    }

    @Override
    public Iterator<GenericFormatImportOperationResult> iterator() {
        return this.fishingOperationResults.values().iterator();
    }
}

