/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.MruCacheStorage;
import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.StringBuiltins;
import freemarker.core.UnexpectedTypeException;
import freemarker.core._DelayedGetMessage;
import freemarker.core._TemplateModelException;
import freemarker.log.Logger;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class _RegexBuiltins {
    private static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static volatile boolean flagWarningsEnabled = logger.isWarnEnabled();
    private static final int MAX_FLAG_WARNINGS_LOGGED = 25;
    private static final Object flagWarningsCntSync = new Object();
    private static int flagWarningsCnt;
    static final MruCacheStorage patternCache;
    private static final long RE_FLAG_CASE_INSENSITIVE;
    private static final long RE_FLAG_MULTILINE;
    private static final long RE_FLAG_COMMENTS;
    private static final long RE_FLAG_DOTALL;
    private static final long RE_FLAG_REGEXP = 0x100000000L;
    private static final long RE_FLAG_FIRST_ONLY = 0x200000000L;

    private _RegexBuiltins() {
    }

    private static long intFlagToLong(int flag) {
        return (long)flag & 0xFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pattern getPattern(String patternString, int flags) throws TemplateModelException {
        Pattern result;
        PatternCacheKey patternKey = new PatternCacheKey(patternString, flags);
        MruCacheStorage mruCacheStorage = patternCache;
        synchronized (mruCacheStorage) {
            result = (Pattern)patternCache.get(patternKey);
        }
        if (result != null) {
            return result;
        }
        try {
            result = Pattern.compile(patternString, flags);
        }
        catch (PatternSyntaxException e) {
            throw new _TemplateModelException((Throwable)e, new Object[]{"Malformed regular expression: ", new _DelayedGetMessage(e)});
        }
        mruCacheStorage = patternCache;
        synchronized (mruCacheStorage) {
            patternCache.put(patternKey, result);
        }
        return result;
    }

    private static long parseFlagString(String flagString) {
        long flags = 0L;
        block8: for (int i = 0; i < flagString.length(); ++i) {
            char c = flagString.charAt(i);
            switch (c) {
                case 'i': {
                    flags |= RE_FLAG_CASE_INSENSITIVE;
                    continue block8;
                }
                case 'm': {
                    flags |= RE_FLAG_MULTILINE;
                    continue block8;
                }
                case 'c': {
                    flags |= RE_FLAG_COMMENTS;
                    continue block8;
                }
                case 's': {
                    flags |= RE_FLAG_DOTALL;
                    continue block8;
                }
                case 'r': {
                    flags |= 0x100000000L;
                    continue block8;
                }
                case 'f': {
                    flags |= 0x200000000L;
                    continue block8;
                }
                default: {
                    if (!flagWarningsEnabled) continue block8;
                    _RegexBuiltins.logFlagWarning("Unrecognized regular expression flag: " + StringUtil.jQuote(String.valueOf(c)) + ".");
                }
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logFlagWarning(String message) {
        int cnt;
        if (!flagWarningsEnabled) {
            return;
        }
        Object object = flagWarningsCntSync;
        synchronized (object) {
            cnt = flagWarningsCnt++;
            if (cnt >= 25) {
                flagWarningsEnabled = false;
                return;
            }
        }
        message = message + " This will be an error in FreeMarker 2.4!";
        if (cnt + 1 == 25) {
            message = message + " [Will not log more regular expression flag problems until restart!]";
        }
        logger.warn(message);
    }

    private static void checkNonRegexpFlags(String biName, long flags) {
        if (!flagWarningsEnabled) {
            return;
        }
        if ((flags & RE_FLAG_MULTILINE) != 0L) {
            _RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"m\" flag " + "without the \"r\" flag.");
        }
        if ((flags & RE_FLAG_DOTALL) != 0L) {
            _RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"s\" flag " + "without the \"r\" flag.");
        }
        if ((flags & RE_FLAG_COMMENTS) != 0L) {
            _RegexBuiltins.logFlagWarning("?" + biName + " doesn't support the \"c\" flag " + "without the \"r\" flag.");
        }
    }

    static {
        patternCache = new MruCacheStorage(50, 150);
        RE_FLAG_CASE_INSENSITIVE = _RegexBuiltins.intFlagToLong(2);
        RE_FLAG_MULTILINE = _RegexBuiltins.intFlagToLong(8);
        RE_FLAG_COMMENTS = _RegexBuiltins.intFlagToLong(4);
        RE_FLAG_DOTALL = _RegexBuiltins.intFlagToLong(32);
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateCollectionModel,
    TemplateSequenceModel {
        final Matcher matcher;
        final String input;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList data;

        RegexMatchModel(Matcher matcher, String input) {
            this.matcher = matcher;
            this.input = input;
            this.matches = matcher.matches();
        }

        public boolean getAsBoolean() {
            return this.matches;
        }

        public TemplateModel get(int i) throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return (TemplateModel)this.data.get(i);
        }

        public int size() throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() throws TemplateModelException {
            this.data = new ArrayList();
            TemplateModelIterator it = this.iterator();
            while (it.hasNext()) {
                this.data.add(it.next());
            }
        }

        public TemplateModel getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    public int size() throws TemplateModelException {
                        try {
                            return RegexMatchModel.this.matcher.groupCount() + 1;
                        }
                        catch (Exception e) {
                            throw new _TemplateModelException((Throwable)e);
                        }
                    }

                    public TemplateModel get(int i) throws TemplateModelException {
                        try {
                            return new SimpleScalar(RegexMatchModel.this.matcher.group(i));
                        }
                        catch (Exception e) {
                            throw new _TemplateModelException((Throwable)e);
                        }
                    }
                };
            }
            return this.groups;
        }

        public TemplateModelIterator iterator() {
            this.matcher.reset();
            return new TemplateModelIterator(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                }

                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                public TemplateModel next() throws TemplateModelException {
                    if (!this.hasNext()) {
                        throw new _TemplateModelException("No more matches");
                    }
                    Match result = new Match();
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                    return result;
                }
            };
        }

        class Match
        implements TemplateScalarModel {
            String match;
            SimpleSequence subs = new SimpleSequence();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            public String getAsString() {
                return this.match;
            }
        }
    }

    public static class split_reBI
    extends StringBuiltins.StringBuiltIn {
        TemplateModel calculateResult(String s, Environment env) throws TemplateModelException {
            return new SplitMethod(s);
        }

        class SplitMethod
        implements TemplateMethodModel {
            private String s;

            SplitMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int argCnt = args.size();
                split_reBI.this.checkMethodArgCount(argCnt, 1, 2);
                String splitString = (String)args.get(0);
                long flags = argCnt > 1 ? _RegexBuiltins.parseFlagString((String)args.get(1)) : 0L;
                String[] result = null;
                if ((flags & 0x100000000L) == 0L) {
                    _RegexBuiltins.checkNonRegexpFlags("split", flags);
                    result = StringUtil.split(this.s, splitString, (flags & RE_FLAG_CASE_INSENSITIVE) != 0L);
                } else {
                    Pattern pattern = _RegexBuiltins.getPattern(splitString, (int)flags);
                    result = pattern.split(this.s);
                }
                return ObjectWrapper.DEFAULT_WRAPPER.wrap(result);
            }
        }
    }

    public static class replace_reBI
    extends StringBuiltins.StringBuiltIn {
        TemplateModel calculateResult(String s, Environment env) throws TemplateModelException {
            return new ReplaceMethod(s);
        }

        class ReplaceMethod
        implements TemplateMethodModel {
            private String s;

            ReplaceMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                String result;
                long flags;
                int argCnt = args.size();
                replace_reBI.this.checkMethodArgCount(argCnt, 2, 3);
                String arg1 = (String)args.get(0);
                String arg2 = (String)args.get(1);
                long l = flags = argCnt > 2 ? _RegexBuiltins.parseFlagString((String)args.get(2)) : 0L;
                if ((flags & 0x100000000L) == 0L) {
                    _RegexBuiltins.checkNonRegexpFlags("replace", flags);
                    result = StringUtil.replace(this.s, arg1, arg2, (flags & RE_FLAG_CASE_INSENSITIVE) != 0L, (flags & 0x200000000L) != 0L);
                } else {
                    Pattern pattern = _RegexBuiltins.getPattern(arg1, (int)flags);
                    Matcher matcher = pattern.matcher(this.s);
                    result = (flags & 0x200000000L) != 0L ? matcher.replaceFirst(arg2) : matcher.replaceAll(arg2);
                }
                return new SimpleScalar(result);
            }
        }
    }

    public static class groupsBI
    extends BuiltIn {
        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel targetModel = this.target.eval(env);
            this.assertNonNull(targetModel, env);
            if (targetModel instanceof RegexMatchModel) {
                return ((RegexMatchModel)targetModel).getGroups();
            }
            if (targetModel instanceof RegexMatchModel.Match) {
                return ((RegexMatchModel.Match)targetModel).subs;
            }
            throw new UnexpectedTypeException(this.target, targetModel, "regular expression matcher", env);
        }
    }

    public static class matchesBI
    extends StringBuiltins.StringBuiltIn {
        TemplateModel calculateResult(String s, Environment env) throws TemplateModelException {
            return new MatcherBuilder(s);
        }

        class MatcherBuilder
        implements TemplateMethodModel {
            String matchString;

            MatcherBuilder(String matchString) throws TemplateModelException {
                this.matchString = matchString;
            }

            public Object exec(List args) throws TemplateModelException {
                long flags;
                int argCnt = args.size();
                matchesBI.this.checkMethodArgCount(argCnt, 1, 2);
                String patternString = (String)args.get(0);
                long l = flags = argCnt > 1 ? _RegexBuiltins.parseFlagString((String)args.get(1)) : 0L;
                if ((flags & 0x200000000L) != 0L) {
                    _RegexBuiltins.logFlagWarning("?" + matchesBI.this.key + " doesn't support the \"f\" flag.");
                }
                Pattern pattern = _RegexBuiltins.getPattern(patternString, (int)flags);
                Matcher matcher = pattern.matcher(this.matchString);
                return new RegexMatchModel(matcher, this.matchString);
            }
        }
    }

    private static class PatternCacheKey {
        private final String patternString;
        private final int flags;
        private final int hashCode;

        public PatternCacheKey(String patternString, int flags) {
            this.patternString = patternString;
            this.flags = flags;
            this.hashCode = patternString.hashCode() + 31 * flags;
        }

        public boolean equals(Object that) {
            if (that instanceof PatternCacheKey) {
                PatternCacheKey thatPCK = (PatternCacheKey)that;
                return thatPCK.flags == this.flags && thatPCK.patternString.equals(this.patternString);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

