/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeProperty;
import liquibase.change.custom.CustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.statement.SqlStatement;
import liquibase.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomChangeWrapper
extends AbstractChange {
    @ChangeProperty(includeInSerialization=false)
    private CustomChange customChange;
    private String className;
    @ChangeProperty(includeInSerialization=false)
    private SortedSet<String> params = new TreeSet<String>();
    private Map<String, String> paramValues = new HashMap<String, String>();
    @ChangeProperty(includeInSerialization=false)
    private ClassLoader classLoader;

    public CustomChangeWrapper() {
        super("customChange", "Custom Change", 1);
    }

    public CustomChange getCustomChange() {
        return this.customChange;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClass(String className) throws CustomChangeException {
        this.className = className;
        try {
            try {
                this.customChange = (CustomChange)Class.forName(className, true, this.classLoader).newInstance();
            }
            catch (ClassCastException e) {
                try {
                    this.customChange = (CustomChange)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                }
                catch (ClassNotFoundException e1) {
                    this.customChange = (CustomChange)Class.forName(className).newInstance();
                }
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setParam(String name, String value) {
        this.params.add(name);
        this.paramValues.put(name, value);
    }

    public SortedSet<String> getParams() {
        return this.params;
    }

    public Map<String, String> getParamValues() {
        return this.paramValues;
    }

    @Override
    public ValidationErrors validate(Database database) {
        try {
            return this.customChange.validate(database);
        }
        catch (AbstractMethodError e) {
            return new ValidationErrors();
        }
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements;
        block5: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlChange) {
                    statements = ((CustomSqlChange)this.customChange).generateStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskChange) {
                    ((CustomTaskChange)this.customChange).execute(database);
                    break block5;
                }
                throw new UnexpectedLiquibaseException(this.customChange.getClass().getName() + " does not implement " + CustomSqlChange.class.getName() + " or " + CustomTaskChange.class.getName());
            }
            catch (CustomChangeException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] statements;
        block5: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlRollback) {
                    statements = ((CustomSqlRollback)((Object)this.customChange)).generateRollbackStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskRollback) {
                    ((CustomTaskRollback)((Object)this.customChange)).rollback(database);
                    break block5;
                }
                throw new UnsupportedChangeException("Unknown rollback type: " + this.customChange.getClass().getName());
            }
            catch (CustomChangeException e) {
                throw new UnsupportedChangeException(e);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.customChange instanceof CustomSqlRollback || this.customChange instanceof CustomTaskRollback;
    }

    private void configureCustomChange() throws CustomChangeException {
        try {
            for (String param : this.params) {
                ObjectUtil.setProperty(this.customChange, param, this.paramValues.get(param));
            }
            this.customChange.setFileOpener(this.getResourceAccessor());
            this.customChange.setUp();
        }
        catch (Exception e) {
            throw new CustomChangeException(e);
        }
    }

    @Override
    public String getConfirmationMessage() {
        return this.customChange.getConfirmationMessage();
    }
}

