/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import java.util.List;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.namespace.DimensionNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IDimensionModel;
import org.eclipse.birt.report.model.elements.olap.Hierarchy;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public abstract class Dimension
extends ReferenceableElement
implements IDimensionModel,
INameContainer {
    public static final int LEVEL_NAME_SPACE = 0;
    public static final int NAME_SPACE_COUNT = 1;
    protected INameHelper nameHelper = new DimensionNameHelper(this);

    public Dimension() {
    }

    public Dimension(String name) {
        super(name);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitDimension(this);
    }

    @Override
    public String getElementName() {
        return "Dimension";
    }

    public DesignElement getDefaultHierarchy(Module module) {
        DesignElement hierarchy = this.getReferenceProperty(module, "defaultHierarchy");
        if (hierarchy == null || !this.isValidHierarchy(hierarchy, module)) {
            return null;
        }
        return hierarchy;
    }

    protected boolean isValidHierarchy(DesignElement hierarchy, Module module) {
        return hierarchy.getContainer() == this;
    }

    public void setDefaultHierarchy(Hierarchy defaultHierarchy) {
        this.setProperty("defaultHierarchy", (Object)new ElementRefValue(null, defaultHierarchy));
    }

    public void setDefaultHierarchy(int index) {
        List hierarchies = (List)this.getLocalProperty(this.getRoot(), "hierarchies");
        if (hierarchies == null || hierarchies.isEmpty()) {
            return;
        }
        if (index >= 0 && index < hierarchies.size()) {
            this.setProperty("defaultHierarchy", (Object)new ElementRefValue(null, (DesignElement)hierarchies.get(index)));
        }
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        Module module;
        DesignElement hierarchy;
        DesignElement element = (DesignElement)super.doClone(policy);
        Dimension clonedDimension = (Dimension)element;
        DimensionNameHelper nHelper = new DimensionNameHelper(clonedDimension);
        clonedDimension.nameHelper = nHelper;
        List hierarchies = (List)clonedDimension.getLocalProperty(null, "hierarchies");
        if (hierarchies != null) {
            int i = 0;
            while (i < hierarchies.size()) {
                hierarchy = (Hierarchy)hierarchies.get(i);
                List levels = (List)hierarchy.getLocalProperty(null, "levels");
                if (levels != null) {
                    int j = 0;
                    while (j < levels.size()) {
                        Level level = (Level)levels.get(j);
                        if (level.getName() != null) {
                            nHelper.addElement(level);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((hierarchy = this.getDefaultHierarchy(module = this.getRoot())) != null) {
            int index = hierarchy.getIndex(module);
            DesignElement clonedHierarchy = new ContainerContext(element, "hierarchies").getContent(clonedDimension.getRoot(), index);
            if (clonedHierarchy != null) {
                element.setProperty("defaultHierarchy", (Object)new ElementRefValue(null, clonedHierarchy));
            }
        }
        return element;
    }

    @Override
    public INameHelper getNameHelper() {
        return this.nameHelper;
    }

    @Override
    public void makeUniqueName(DesignElement element) {
        new NameExecutor(this.getRoot(), this, element).makeUniqueName();
    }

    @Override
    public void rename(DesignElement element) {
        new NameExecutor(this.getRoot(), this, element).rename();
    }

    public DesignElement getLocalHierarchy(Module module, String hierarchyName) {
        List hierarchies = (List)super.getLocalProperty(module, "hierarchies");
        if (hierarchies == null || hierarchies.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < hierarchies.size()) {
            DesignElement tmpElement = (DesignElement)hierarchies.get(i);
            if (hierarchyName.equalsIgnoreCase(tmpElement.getName())) {
                return tmpElement;
            }
            ++i;
        }
        return null;
    }
}

