/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import org.eclipse.birt.report.engine.content.IContent;
import org.w3c.dom.css.CSSValue;

public class BidiAlignmentResolver {
    public static String getDefaultAlignment(boolean rtl) {
        if (rtl) {
            return "right";
        }
        return "left";
    }

    public static String getDefaultAlignment(String direction) {
        return BidiAlignmentResolver.getDefaultAlignment("rtl".equals(direction));
    }

    public static String resolveAlignmentForDesigner(String alignment, String direction, boolean mirrored) {
        if (alignment == null || "justify".equals(alignment)) {
            alignment = BidiAlignmentResolver.getDefaultAlignment(direction);
        }
        if (!mirrored) {
            return alignment;
        }
        if ("right".equals(alignment)) {
            return "left";
        }
        if ("left".equals(alignment)) {
            return "right";
        }
        return alignment;
    }

    public static boolean isRightAligned(IContent content, String align, boolean lastLine) {
        return "right".equalsIgnoreCase(align) || content != null && content.isDirectionRTL() && (align == null || lastLine && "justify".equalsIgnoreCase(align));
    }

    public static boolean isRightAligned(IContent content, CSSValue align, boolean lastLine) {
        return BidiAlignmentResolver.isRightAligned(content, align != null ? align.getCssText() : null, lastLine);
    }
}

