/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.i18n.Messages;

public abstract class AbstractConfigurableOptionObserver
implements IConfigurableOptionObserver {
    private static final String CHART_DPI = "ChartDpi";
    protected IOptionValue[] values;

    public IOptionValue[] getOptionValues() {
        return this.values;
    }

    public IConfigurableOption[] getOptions() {
        return null;
    }

    public IRenderOption getPreferredRenderOption() {
        return null;
    }

    public boolean update(IOptionValue ... values) {
        this.values = values;
        return false;
    }

    public List validate(IOptionValue ... values) {
        LinkedList<BirtException> errors = new LinkedList<BirtException>();
        IOptionValue[] iOptionValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Object value;
                IOptionValue option = iOptionValueArray[n2];
                if (CHART_DPI.equals(option.getName()) && (value = option.getValue()) != null) {
                    int resolution = 0;
                    if (value instanceof Number) {
                        resolution = ((Number)value).intValue();
                    } else {
                        try {
                            resolution = Integer.parseInt(value.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            errors.add(new BirtException(Messages.getString("INVALID_CHART_DPI")));
                            break block7;
                        }
                    }
                    if (resolution < 96) {
                        errors.add(new BirtException(Messages.getString("TOO_SMALL_CHART_DPI")));
                    }
                }
            }
            ++n2;
        }
        return errors;
    }
}

