/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.script.api.attribute.ILabel;
import org.eclipse.birt.chart.script.api.attribute.IText;
import org.eclipse.birt.chart.script.api.data.IDataElement;
import org.eclipse.birt.chart.script.api.data.IDateTimeDataElement;
import org.eclipse.birt.chart.script.api.data.INumberDataElement;
import org.eclipse.birt.chart.script.internal.attribute.ColorImpl;
import org.eclipse.birt.chart.script.internal.attribute.FontImpl;
import org.eclipse.birt.chart.script.internal.attribute.LabelImpl;
import org.eclipse.birt.chart.script.internal.attribute.TextImpl;
import org.eclipse.birt.chart.script.internal.data.DateTimeElementImpl;
import org.eclipse.birt.chart.script.internal.data.NumberElementImpl;
import org.eclipse.birt.report.model.api.extension.IColor;
import org.eclipse.birt.report.model.api.extension.IFont;
import org.eclipse.emf.common.util.EList;

public class ChartComponentUtil {
    public static ColorDefinition createEMFColor() {
        ColorDefinition cd = ColorDefinitionImpl.BLACK();
        return cd;
    }

    public static FontDefinition createEMFFont() {
        FontDefinition fd = FontDefinitionImpl.createEmpty();
        return fd;
    }

    public static Text createEMFText() {
        Text desc = org.eclipse.birt.chart.model.attribute.impl.TextImpl.create("");
        desc.setColor(ChartComponentUtil.createEMFColor());
        desc.setFont(ChartComponentUtil.createEMFFont());
        return desc;
    }

    public static Label createEMFLabel() {
        Label label = org.eclipse.birt.chart.model.component.impl.LabelImpl.create();
        label.setCaption(ChartComponentUtil.createEMFText());
        label.setVisible(true);
        return label;
    }

    public static IDataElement convertDataElement(DataElement data) {
        if (data instanceof NumberDataElement) {
            return new NumberElementImpl((NumberDataElement)data);
        }
        if (data instanceof DateTimeDataElement) {
            return new DateTimeElementImpl((DateTimeDataElement)data);
        }
        return null;
    }

    public static DataElement convertIDataElement(IDataElement data) {
        if (data instanceof INumberDataElement) {
            return NumberDataElementImpl.create(((INumberDataElement)data).getValue());
        }
        if (data instanceof IDateTimeDataElement) {
            return DateTimeDataElementImpl.create(((IDateTimeDataElement)data).getValue());
        }
        return null;
    }

    public static IText convertText(Text text) {
        if (text == null) {
            text = ChartComponentUtil.createEMFText();
        }
        return new TextImpl(text);
    }

    public static Text convertIText(IText itext) {
        return org.eclipse.birt.chart.model.attribute.impl.TextImpl.create(itext.getValue());
    }

    public static ILabel convertLabel(Label label) {
        if (label == null) {
            label = ChartComponentUtil.createEMFLabel();
        }
        return new LabelImpl(label);
    }

    public static Label convertILabel(ILabel ilabel) {
        Label label = org.eclipse.birt.chart.model.component.impl.LabelImpl.create();
        label.setVisible(ilabel.isVisible());
        label.setCaption(ChartComponentUtil.convertIText(ilabel.getCaption()));
        return label;
    }

    public static IFont convertFont(FontDefinition fd) {
        if (fd == null) {
            fd = ChartComponentUtil.createEMFFont();
        }
        return new FontImpl(fd);
    }

    public static FontDefinition convertIFont(IFont font) {
        return FontDefinitionImpl.create(font.getName(), font.getSize(), font.isBold(), font.isItalic(), font.isUnderline(), font.isStrikeThrough(), false, 0.0, null);
    }

    public static IColor convertColor(ColorDefinition cd) {
        if (cd == null) {
            cd = ChartComponentUtil.createEMFColor();
        }
        return new ColorImpl(cd);
    }

    public static ColorDefinition convertIColor(IColor color) {
        ColorDefinition cd = ColorDefinitionImpl.create(color.getRed(), color.getGreen(), color.getBlue());
        cd.setTransparency(color.getTransparency());
        return cd;
    }

    public static List getOrthogonalSeriesDefinitions(Chart chart, int axisIndex) {
        ArrayList<SeriesDefinition> seriesList = new ArrayList<SeriesDefinition>();
        if (chart instanceof ChartWithAxes) {
            EList<Axis> axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                if (axisIndex < 0 || axisIndex == i) {
                    seriesList.addAll((Collection<SeriesDefinition>)((Axis)axisList.get(i)).getSeriesDefinitions());
                }
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            seriesList.addAll((Collection<SeriesDefinition>)((SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0)).getSeriesDefinitions());
        }
        return seriesList;
    }
}

