/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.computation.withaxes.SharedScaleContext;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.AttributeFactoryImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTChartXtabResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTExternalContext;
import org.eclipse.birt.chart.reportitem.BIRTGroupedQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTMessageLookup;
import org.eclipse.birt.chart.reportitem.BIRTQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTScriptClassLoader;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.SharedCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemConstants;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.ChartScriptContext;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.ReportItemPresentationBase;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.emf.common.util.EList;
import org.mozilla.javascript.EvaluatorException;

public class ChartReportItemPresentationBase
extends ReportItemPresentationBase
implements ChartReportItemConstants {
    protected InputStream fis = null;
    protected String imageMap = null;
    protected String sExtension = null;
    protected String outputChartFormat = "";
    protected int outputType = -1;
    protected Chart cm = null;
    protected IDeviceRenderer idr = null;
    protected RunTimeContext rtc = null;
    private static List<String> registeredDevices = null;
    protected static final ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");
    private Bounds boundsRuntime = null;
    private boolean validCubeResultSet = true;
    protected int renderDpi = 96;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    protected static IDataRowExpressionEvaluator EMPTY_CHART_EVALUATOR;

    static {
        registeredDevices = new ArrayList<String>();
        try {
            String[][] formats = PluginSettings.instance().getRegisteredOutputFormats();
            int i = 0;
            while (i < formats.length) {
                registeredDevices.add(formats[i][0]);
                ++i;
            }
        }
        catch (ChartException e) {
            logger.log(e);
        }
        EMPTY_CHART_EVALUATOR = new IDataRowExpressionEvaluator(){

            @Override
            public void close() {
            }

            @Override
            public Object evaluate(String expression) {
                return null;
            }

            @Override
            public Object evaluateGlobal(String expression) {
                return null;
            }

            @Override
            public boolean first() {
                return false;
            }

            @Override
            public boolean next() {
                return false;
            }
        };
    }

    protected boolean isOutputRendererSupported(String format) {
        if (format != null && this.supportedImageFormats != null && this.supportedImageFormats.indexOf(format) != -1) {
            return registeredDevices.contains(format);
        }
        return false;
    }

    protected String getFirstSupportedFormat() {
        String[] array;
        if (this.supportedImageFormats != null && this.supportedImageFormats.trim().length() > 0 && (array = this.supportedImageFormats.split(";")).length > 0) {
            int i = 0;
            while (i < array.length) {
                if (this.isOutputRendererSupported(array[i])) {
                    return array[i];
                }
                ++i;
            }
        }
        return "PNG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModelObject(ExtendedItemHandle eih) {
        ExtendedItemHandle refHandle;
        super.setModelObject(eih);
        IReportItem item = this.getReportItem(eih);
        if (item == null) {
            return;
        }
        this.cm = (Chart)item.getProperty("chart.instance");
        IReportItem iReportItem = item;
        synchronized (iReportItem) {
            if (this.cm != null) {
                try {
                    this.cm = this.cm.copyInstance();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    this.cm = this.cm.copyInstance();
                }
                catch (NullPointerException nullPointerException) {
                    this.cm = this.cm.copyInstance();
                }
            }
        }
        if (this.cm != null && eih.getDataBindingReference() != null && ChartItemUtil.isChartHandle(eih.getDataBindingReference()) && (refHandle = ChartItemUtil.getChartReferenceItemHandle(eih)) != null) {
            ChartReportItemUtil.copyChartSeriesDefinition(ChartItemUtil.getChartFromHandle(refHandle), this.cm);
        }
        this.setChartModelObject(item);
    }

    protected void setChartModelObject(IReportItem item) {
        Object of = this.modelHandle.getProperty("outputFormat");
        if (of instanceof String) {
            this.outputChartFormat = (String)of;
        }
        if ((of = item.getProperty("chart.scale")) instanceof SharedScaleContext) {
            if (this.rtc == null) {
                this.rtc = new RunTimeContext();
            }
            this.rtc.setSharedScale((SharedScaleContext)of);
        }
    }

    protected IReportItem getReportItem(ExtendedItemHandle eih) {
        IReportItem item = null;
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(e);
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log(eeex);
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
            }
        }
        return item;
    }

    @Override
    public final void setLocale(Locale lcl) {
        if (this.rtc == null) {
            this.rtc = new RunTimeContext();
        }
        this.rtc.setLocale(lcl);
    }

    @Override
    public void setOutputFormat(String sOutputFormat) {
        super.setOutputFormat(sOutputFormat);
        this.sExtension = sOutputFormat.equalsIgnoreCase("HTML") ? (this.isOutputRendererSupported(this.outputChartFormat) ? this.outputChartFormat : (this.outputChartFormat.equalsIgnoreCase("GIF") && this.isOutputRendererSupported("PNG") ? "PNG" : (this.isOutputRendererSupported("SVG") ? "SVG" : this.getFirstSupportedFormat()))) : (this.isOutputRendererSupported(this.outputChartFormat) ? this.outputChartFormat : this.getFirstSupportedFormat());
    }

    @Override
    public void deserialize(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if ("org.eclipse.birt.chart.internal.script.ChartScriptContext".equals(desc.getName())) {
                        return ChartScriptContext.class;
                    }
                    return super.resolveClass(desc);
                }
            };
            Object o = SecurityUtil.readObject(ois);
            if (o instanceof RunTimeContext) {
                Object oMaxRow;
                RunTimeContext drtc = (RunTimeContext)o;
                if (this.rtc != null) {
                    drtc.setULocale(this.rtc.getULocale());
                    drtc.setSharedScale(this.rtc.getSharedScale());
                }
                this.rtc = drtc;
                if (this.cm != null && this.modelHandle != null) {
                    IReportItem item = this.modelHandle.getReportItem();
                    ((ChartReportItemImpl)item).setSharedScale(this.rtc.getSharedScale());
                }
                if ((oMaxRow = this.context.getAppContext().get("EXTENDED_ITEM_MAX_ROW")) != null) {
                    this.rtc.putState("CHART_MAX_ROW", oMaxRow);
                } else {
                    oMaxRow = this.context.getGlobalVariable("EXTENDED_ITEM_MAX_ROW");
                    if (oMaxRow != null) {
                        this.rtc.putState("CHART_MAX_ROW", oMaxRow);
                    }
                }
                Object chartConvertTimeOut = this.context.getAppContext().get("BIRT_CHART_CONVERT_TO_IMAGE_TIME_OUT");
                if (chartConvertTimeOut != null) {
                    this.rtc.putState("BIRT_CHART_CONVERT_TO_IMAGE_TIME_OUT", chartConvertTimeOut);
                } else {
                    chartConvertTimeOut = this.context.getGlobalVariable("BIRT_CHART_CONVERT_TO_IMAGE_TIME_OUT");
                    if (chartConvertTimeOut != null) {
                        this.rtc.putState("BIRT_CHART_CONVERT_TO_IMAGE_TIME_OUT", chartConvertTimeOut);
                    }
                }
            }
            ois.close();
        }
        catch (Exception e) {
            logger.log(e);
        }
    }

    @Override
    public int getOutputType() {
        if (this.outputType == -1) {
            this.outputType = "SVG".equals(this.sExtension) || "SWF".equals(this.sExtension) ? 1 : 6;
        }
        return this.outputType;
    }

    @Override
    public String getImageMIMEType() {
        if (this.idr == null) {
            return null;
        }
        return this.idr.getMimeType();
    }

    @Override
    public Object getOutputContent() {
        return null;
    }

    @Override
    public void finish() {
        try {
            this.imageMap = null;
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException ioex) {
            logger.log(ioex);
        }
        if (this.idr != null) {
            this.idr.dispose();
            this.idr = null;
        }
    }

    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = originalBounds.copyInstance();
        if (!bounds.isSetHeight()) {
            bounds.setHeight(130.0);
        }
        if (!bounds.isSetWidth()) {
            bounds.setWidth(212.0);
        }
        return bounds;
    }

    protected IDataRowExpressionEvaluator createEvaluator(IBaseResultSet set) throws BirtException {
        if (set instanceof IQueryResultSet) {
            boolean isSharingChart;
            if (ChartReportItemUtil.isOldChartUsingInternalGroup(this.modelHandle, this.cm)) {
                return new BIRTQueryResultSetEvaluator((IQueryResultSet)set);
            }
            boolean bl = isSharingChart = this.modelHandle.getDataBindingReference() != null && ChartItemUtil.isChartHandle(this.modelHandle.getDataBindingReference());
            if (ChartItemUtil.isGroupingDefined(this.cm) || ChartItemUtil.hasAggregation(this.cm) || isSharingChart) {
                return this.createGroupedResultSetEvalator(set);
            }
            return new BIRTQueryResultSetEvaluator((IQueryResultSet)set);
        }
        if (set instanceof ICubeResultSet) {
            if (ChartCubeUtil.isPlotChart(this.modelHandle) || ChartCubeUtil.isAxisChart(this.modelHandle)) {
                return new BIRTChartXtabResultSetEvaluator((ICubeResultSet)set, this.modelHandle);
            }
            ReportItemHandle itemHandle = ChartItemUtil.getReportItemReference(this.modelHandle);
            boolean isChartCubeReference = ChartItemUtil.isChartReportItemHandle(itemHandle);
            CrosstabCellHandle xtabCell = ChartCubeUtil.getXtabContainerCell(this.modelHandle, false);
            if (itemHandle != null && !isChartCubeReference || xtabCell != null && !(xtabCell instanceof AggregationCellHandle)) {
                return this.createSharedCubeRSEvaluator(set);
            }
            return ChartReportItemUtil.instanceCubeEvaluator(this.modelHandle, this.cm, (ICubeResultSet)set);
        }
        return EMPTY_CHART_EVALUATOR;
    }

    protected IDataRowExpressionEvaluator createGroupedResultSetEvalator(IBaseResultSet set) throws ChartException {
        return new BIRTGroupedQueryResultSetEvaluator((IQueryResultSet)set, ChartItemUtil.isSetSummaryAggregation(this.cm), this.isSubQuery(), this.cm, this.modelHandle);
    }

    protected IDataRowExpressionEvaluator createSharedCubeRSEvaluator(IBaseResultSet set) {
        return new SharedCubeResultSetEvaluator((ICubeResultSet)set, this.cm);
    }

    protected boolean isSubQuery() {
        return this.modelHandle.getDataSet() == null;
    }

    protected SharedScaleContext createSharedScale(IBaseResultSet baseResultSet) throws BirtException {
        if (baseResultSet instanceof IQueryResultSet) {
            Object min = baseResultSet.evaluate("row._outer[\"chart__min\"]");
            Object max = baseResultSet.evaluate("row._outer[\"chart__max\"]");
            return SharedScaleContext.createInstance(min, max);
        }
        if (baseResultSet instanceof CubeResultSet) {
            try {
                List edgeCursors = ((CubeResultSet)baseResultSet).getCubeCursor().getOrdinateEdge();
                for (EdgeCursor edge : edgeCursors) {
                    edge.first();
                }
                Axis xAxis = (Axis)((ChartWithAxes)this.cm).getAxes().get(0);
                SeriesDefinition sdValue = (SeriesDefinition)((ChartWithAxes)this.cm).getOrthogonalAxes(xAxis, true)[0].getSeriesDefinitions().get(0);
                Query queryValue = (Query)sdValue.getDesignTimeSeries().getDataDefinition().get(0);
                String bindingValue = this.exprCodec.getCubeBindingName(queryValue.getDefinition(), false);
                String maxBindingName = "chart__max" + bindingValue;
                String minBindingName = "chart__min" + bindingValue;
                Object min = baseResultSet.evaluate(ExpressionUtil.createJSDataExpression(minBindingName));
                Object max = baseResultSet.evaluate(ExpressionUtil.createJSDataExpression(maxBindingName));
                if (min != null && max != null) {
                    return SharedScaleContext.createInstance(min, max);
                }
            }
            catch (OLAPException e) {
                logger.log(e);
            }
            catch (BirtException birtException) {
            }
            catch (EvaluatorException evaluatorException) {}
        }
        return null;
    }

    @Override
    public Size getSize() {
        if (this.boundsRuntime != null) {
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeStart"));
            Size sz = new Size();
            sz.setWidth((float)this.boundsRuntime.getWidth());
            sz.setHeight((float)this.boundsRuntime.getHeight());
            sz.setUnit("pt");
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeEnd"));
            return sz;
        }
        return super.getSize();
    }

    protected boolean bindData(IDataRowExpressionEvaluator rowAdapter, IActionEvaluator evaluator) throws BirtException {
        boolean bNotEmpty = true;
        try {
            Generator.instance().bindData(rowAdapter, evaluator, this.cm, this.rtc);
            bNotEmpty = true;
        }
        catch (BirtException birtException) {
            if (this.isNoDataException(birtException)) {
                bNotEmpty = false;
            }
            if (!ChartReportItemUtil.validateCubeResultSetBinding(this.modelHandle, this.cm)) {
                this.validCubeResultSet = false;
            }
            throw birtException;
        }
        this.rtc.putState(RunTimeContext.StateKey.DATA_EMPTY_KEY, !bNotEmpty);
        return bNotEmpty;
    }

    @Override
    public Object onRowSets(IBaseResultSet[] baseResultSet) throws BirtException {
        Object renderObject;
        block15: {
            boolean bEmptyData;
            block14: {
                Bounds bo;
                if (this.cm == null) {
                    return null;
                }
                IBaseResultSet resultSet = this.getDataToRender(baseResultSet);
                boolean bEmpty = false;
                boolean bEmptyWithUncompletedBindings = false;
                boolean bEmptyWithEmptyResultSet = false;
                if (resultSet == null || !ChartItemUtil.checkChartBindingComplete(this.cm)) {
                    bEmpty = true;
                    bEmptyWithUncompletedBindings = true;
                }
                if (!bEmpty && ChartReportItemUtil.isEmpty(resultSet)) {
                    bEmpty = true;
                    bEmptyWithEmptyResultSet = true;
                }
                if ((bo = this.cm.getBlock().getBounds()).getWidth() == 0.0 && bo.getHeight() == 0.0 && (bo.isSetHeight() || bo.isSetWidth())) {
                    return null;
                }
                this.renderDpi = this.getRenderDpi();
                try {
                    this.rtc.setTimeZone(this.context.getTimeZone());
                    if (this.rtc.getSharedScale() == null && ChartReportItemUtil.canScaleShared(this.modelHandle, this.cm)) {
                        this.rtc.setSharedScale(this.createSharedScale(resultSet));
                    }
                    boolean isSharingQuery = false;
                    if (this.modelHandle.getDataBindingReference() != null || this.modelHandle.getContainer() instanceof MultiViewsHandle || ChartItemUtil.isChartInheritGroups(this.modelHandle)) {
                        isSharingQuery = true;
                        isSharingQuery &= !ChartItemUtil.isChartHandle(ChartItemUtil.getReportItemReference(this.modelHandle));
                    }
                    this.rtc.setSharingQuery(isSharingQuery);
                    BIRTExternalContext externalContext = new BIRTExternalContext(this.context);
                    if (this.rtc.getScriptContext() != null && this.rtc.getScriptContext() instanceof ChartScriptContext) {
                        ((ChartScriptContext)this.rtc.getScriptContext()).setExternalContext(externalContext);
                    }
                    this.initializeScriptHandler(externalContext);
                    IDataRowExpressionEvaluator rowAdapter = this.createEvaluator(resultSet);
                    BIRTActionEvaluator evaluator = new BIRTActionEvaluator();
                    ChartReportStyleProcessor styleProcessor = new ChartReportStyleProcessor(this.modelHandle, true, this.style, this.dpi, this.rtc.getULocale());
                    styleProcessor.applyDefaultHyperlink(this.cm);
                    this.updateChartModel();
                    bEmptyData = false;
                    if (!bEmptyWithUncompletedBindings && !this.bindData(rowAdapter, evaluator)) {
                        bEmptyData = true;
                    }
                    if (!this.validCubeResultSet) {
                        this.outputType = 3;
                        return "<p align='left'>" + Messages.getString("ChartReportItemPresentationImpl.error.InvalidCubeBinding") + "</p>";
                    }
                    renderObject = this.generateRenderObject(rowAdapter, externalContext, bEmpty || bEmptyData, styleProcessor);
                    rowAdapter.close();
                    if (!bEmpty) break block14;
                    if (bEmptyWithUncompletedBindings && this.isAutoHide()) {
                        this.boundsRuntime = null;
                        this.idr = null;
                        return this.outputNullResultSet();
                    }
                    if (!bEmptyWithEmptyResultSet || !this.isAutoHide()) break block14;
                    this.boundsRuntime = null;
                    this.idr = null;
                    return null;
                }
                catch (RuntimeException ex) {
                    logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
                    logger.log(ex);
                    throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ex);
                }
            }
            if (!bEmptyData || !this.isAutoHide()) break block15;
            this.boundsRuntime = null;
            this.idr = null;
            return null;
        }
        return renderObject;
    }

    protected Object generateRenderObject(IDataRowExpressionEvaluator rowAdapter, BIRTExternalContext externalContext, boolean bEmpty, IStyleProcessor externalProcessor) throws ChartException {
        if (externalProcessor == null) {
            externalProcessor = new ChartReportStyleProcessor(this.modelHandle, true, this.style, this.dpi);
        }
        this.prepareDeviceRenderer();
        GeneratedChartState gcs = this.buildChart(rowAdapter, externalContext, externalProcessor);
        this.renderToImageFile(gcs);
        if (this.rtc.getSharedScale() != null && !this.rtc.getSharedScale().isShared()) {
            this.rtc.getSharedScale().setShared(true);
            ((ChartReportItemImpl)this.getReportItem(this.modelHandle)).setSharedScale(this.rtc.getSharedScale());
        }
        return this.getImageToDisplay();
    }

    protected IBaseResultSet getDataToRender(IBaseResultSet[] baseResultSet) throws BirtException {
        if (baseResultSet == null || baseResultSet.length < 1) {
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.error.NoData"));
            return null;
        }
        IBaseResultSet resultSet = baseResultSet[0];
        if (resultSet == null) {
            return null;
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsStart"));
        if (this.modelHandle == null) {
            assert (false);
            return null;
        }
        return resultSet;
    }

    private void initializeScriptHandler(BIRTExternalContext externalContext) throws ChartException {
        String javaHandlerClass = this.modelHandle.getEventHandlerClass();
        if (javaHandlerClass != null && javaHandlerClass.length() > 0) {
            this.cm.setScript(javaHandlerClass);
        }
        this.rtc.setScriptClassLoader(new BIRTScriptClassLoader(this.appClassLoader));
        ScriptHandler sh = (ScriptHandler)this.rtc.getScriptHandler();
        if (sh == null) {
            sh = new ScriptHandler();
            this.rtc.setScriptHandler(sh);
            sh.setScriptClassLoader(this.rtc.getScriptClassLoader());
            sh.setScriptContext(this.rtc.getScriptContext());
            String sScriptContent = this.cm.getScript();
            if (externalContext != null && externalContext.getScriptable() != null) {
                sh.init(externalContext.getScriptable());
            } else {
                sh.init(null);
            }
            sh.setRunTimeModel(this.cm);
            if (sScriptContent != null && sScriptContent.length() > 0 && this.rtc.isScriptingEnabled()) {
                sh.register(ModuleUtil.getScriptUID(this.modelHandle.getPropertyHandle("onRender")), sScriptContent);
            }
        }
    }

    protected GeneratedChartState buildChart(IDataRowExpressionEvaluator rowAdapter, BIRTExternalContext externalContext, IStyleProcessor externalProcessor) throws ChartException {
        Bounds bo = this.computeBounds();
        this.initializeRuntimeContext(rowAdapter, bo);
        GeneratedChartState gcs = Generator.instance().build(this.idr.getDisplayServer(), this.cm, bo, externalContext, this.rtc, externalProcessor);
        this.boundsRuntime = gcs.getChartModel().getBlock().getBounds();
        return gcs;
    }

    protected Object getImageToDisplay() {
        if (this.getOutputType() == 1) {
            return this.fis;
        }
        if (this.getOutputType() == 6) {
            return new Object[]{this.fis, this.imageMap};
        }
        throw new IllegalArgumentException();
    }

    private void renderToImageFile(GeneratedChartState gcs) throws ChartException {
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsRendering"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        this.idr.setProperty("device.file.identifier", bos);
        this.idr.setProperty("device.component", new EmptyUpdateNotifier(this.cm, gcs.getChartModel()));
        Generator.instance().render(this.idr, gcs);
        try {
            bos.close();
            this.fis = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception ioex) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ioex);
        }
        if (this.getOutputType() == 6) {
            this.imageMap = this.getImageMap();
        }
    }

    protected String getImageMap() throws ChartException {
        return ((IImageMapEmitter)((Object)this.idr)).getImageMap();
    }

    private boolean isNoDataException(BirtException birtException) {
        Throwable ex = birtException;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 16) {
            return true;
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 20) {
            return true;
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 18) {
            logger.log(birtException);
            return true;
        }
        logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
        logger.log(birtException);
        return false;
    }

    private void initializeRuntimeContext(IDataRowExpressionEvaluator rowAdapter, Bounds bo) {
        this.rtc.setActionRenderer(ChartReportItemUtil.instanceActionRenderer(this.modelHandle, this.ah, rowAdapter, this.context));
        this.rtc.setMessageLookup(new BIRTMessageLookup(this.context));
        this.rtc.setRightToLeftText(this.modelHandle.isDirectionRTL());
        ChartReportItemImpl crii = (ChartReportItemImpl)this.getReportItem(this.modelHandle);
        this.rtc.setRightToLeft(crii.isLayoutDirectionRTL());
        this.rtc.setResourceFinder(crii);
        this.rtc.setExternalizer(crii);
        if (this.rtc.getSharedScale() != null && this.canUpdateScale()) {
            this.rtc.getSharedScale().updateBounds(bo);
        }
    }

    protected void prepareDeviceRenderer() throws ChartException {
        this.idr = ChartEngine.instance().getRenderer("dv." + this.sExtension.toUpperCase(Locale.US));
        this.idr.setProperty("device.resolution", this.dpi);
        this.idr.setProperty("output.format", this.outputFormat);
        this.idr.getDisplayServer().setLocale(this.rtc.getULocale());
        if (this.isAreaAltEnabled()) {
            this.idr.setProperty("enable.area.alt", Boolean.TRUE);
        }
        if ("SVG".equalsIgnoreCase(this.sExtension)) {
            this.idr.setProperty("resize.svg", Boolean.TRUE);
        }
    }

    protected final boolean isAreaAltEnabled() {
        ExtendedProperty altEnabled = ChartUtil.getExtendedProperty(this.cm, "enable.area.alt");
        return altEnabled != null && Boolean.valueOf(altEnabled.getValue()) != false;
    }

    protected void updateChartModel() {
        Bounds b;
        if (this.isAreaAltEnabled() && !"SVG".equalsIgnoreCase(this.sExtension)) {
            for (SeriesDefinition vsd : ChartUtil.getAllOrthogonalSeriesDefinitions(this.cm)) {
                boolean bTooltipsFound = false;
                EList<Trigger> triggers = vsd.getDesignTimeSeries().getTriggers();
                for (Trigger trigger : triggers) {
                    if (trigger.getAction().getType() != ActionType.SHOW_TOOLTIP_LITERAL) continue;
                    bTooltipsFound = true;
                    break;
                }
                if (bTooltipsFound) continue;
                TooltipValue tv = AttributeFactoryImpl.init().createTooltipValue();
                Trigger t = TriggerImpl.create(TriggerCondition.ONMOUSEOVER_LITERAL, ActionImpl.create(ActionType.SHOW_TOOLTIP_LITERAL, tv));
                triggers.add(t);
            }
        }
        if ((b = ChartItemUtil.computeChartBounds(this.modelHandle, this.renderDpi)) != null) {
            this.cm.getBlock().setBounds(b);
        }
    }

    protected int getRenderDpi() {
        int imageDpi;
        Object renderDpi = this.context.getRenderOption().getOption("RenderDpi");
        if (renderDpi instanceof Integer) {
            return (Integer)renderDpi;
        }
        if (this.modelHandle.getRoot() instanceof ReportDesignHandle && (imageDpi = ((ReportDesignHandle)this.modelHandle.getRoot()).getImageDPI()) > 0) {
            return imageDpi;
        }
        try {
            int screenDpi = Toolkit.getDefaultToolkit().getScreenResolution();
            if (screenDpi > 0) {
                return screenDpi;
            }
        }
        catch (Exception exception) {}
        return 96;
    }

    protected boolean isAutoHide() {
        return this.cm != null && !this.cm.getEmptyMessage().isVisible();
    }

    protected boolean canUpdateScale() {
        return false;
    }

    protected Object outputNullResultSet() {
        return new Object[]{new byte[1]};
    }

    @Override
    public boolean isCacheable() {
        return this.cm == null || this.cm.getScript() == null || this.cm.getScript().trim().length() <= 0;
    }
}

