/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.sanity.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesImpl;
import fr.ifremer.adagio.core.service.technical.sanity.task.DatabaseSanityTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class DatabaseSanityTaskVesselFeatures
implements DatabaseSanityTask {
    private static final Log log = LogFactory.getLog(DatabaseSanityTaskVesselFeatures.class);

    @Override
    public Set<String> sanity(Session currentSession) {
        HashSet cacheIds = Sets.newHashSet();
        Query query = currentSession.createQuery("SELECT vessel.code FROM " + VesselFeaturesImpl.class.getName() + " WHERE endDateTime IS NULL GROUP BY vessel.code HAVING COUNT(id)>1");
        List vesselCodes = query.list();
        if (CollectionUtils.isEmpty((Collection)vesselCodes)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"vesselFeatures are sane");
            }
            return cacheIds;
        }
        for (String vesselCode : vesselCodes) {
            Query query1 = currentSession.createQuery("SELECT id FROM " + VesselFeaturesImpl.class.getName() + " WHERE endDateTime IS NULL AND vessel.code = :vesselCode ORDER BY startDateTime DESC");
            query1.setString("vesselCode", vesselCode);
            ArrayList vesselFeaturesIds = Lists.newArrayList((Iterable)query1.list());
            vesselFeaturesIds.remove(0);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Remove %d bad vesselFeature with vessel: %s", vesselFeaturesIds.size(), vesselCode));
            }
            currentSession.createQuery("DELETE FROM " + VesselFeaturesImpl.class.getName() + " WHERE id in :id").setParameterList("id", (Collection)vesselFeaturesIds).executeUpdate();
        }
        currentSession.setFlushMode(FlushMode.COMMIT);
        currentSession.flush();
        cacheIds.add("fishingVessels");
        cacheIds.add("vesselByCode");
        return cacheIds;
    }
}

