/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.extension.IChoiceDefinition;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;

public class ExtensionChoice
extends Choice {
    IChoiceDefinition extChoice = null;
    IMessages messages = null;
    Object value = null;
    String defaultDisplayName = null;

    public ExtensionChoice(IMessages messages) {
        this.messages = messages;
    }

    public ExtensionChoice(IChoiceDefinition extChoiceDefn, IMessages messages) {
        assert (extChoiceDefn != null);
        this.extChoice = extChoiceDefn;
        this.messages = messages;
    }

    @Override
    public String getDisplayName() {
        String displayName;
        String resourceKey = this.displayNameKey;
        String choiceName = this.name;
        if (this.extChoice != null) {
            resourceKey = this.extChoice.getDisplayNameID();
            choiceName = this.extChoice.getName();
        }
        if (resourceKey != null && this.messages != null && !StringUtil.isBlank(displayName = this.messages.getMessage(resourceKey, ThreadResources.getLocale()))) {
            return displayName;
        }
        if (this.defaultDisplayName != null) {
            return this.defaultDisplayName;
        }
        return choiceName;
    }

    @Override
    public String getDisplayNameKey() {
        if (this.extChoice != null) {
            return this.extChoice.getDisplayNameID();
        }
        return this.displayNameKey;
    }

    @Override
    public String getName() {
        if (this.extChoice != null) {
            return this.extChoice.getName();
        }
        return this.name;
    }

    @Override
    public Object getValue() {
        if (this.extChoice != null) {
            return this.extChoice.getValue();
        }
        return this.value;
    }

    @Override
    public void setDisplayNameKey(String theDisplayNameKey) {
        this.displayNameKey = theDisplayNameKey;
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setDefaultDisplayName(String defaultDisplayName) {
        this.defaultDisplayName = defaultDisplayName;
    }

    @Override
    public int compareTo(Object o) {
        Choice choice = (Choice)o;
        String name = this.getName();
        assert (name != null);
        return name.compareTo(choice.getName());
    }
}

