/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportExecutorUtil {
    public static void execute(IReportExecutor executor, IContentEmitter emitter) throws BirtException {
        IReportContent report = executor.execute();
        emitter.start(report);
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            ReportExecutorUtil.execute(childExecutor, emitter);
        }
        emitter.end(report);
    }

    public static void execute(IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        IContent content = executor.execute();
        if (content != null) {
            ContentEmitterUtil.startContent(content, emitter);
        }
        ReportExecutorUtil.executeAll(executor, emitter);
        if (content != null) {
            ContentEmitterUtil.endContent(content, emitter);
        }
        executor.close();
    }

    public static IPageContent executeMasterPage(IReportExecutor executor, long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        IReportItemExecutor pageExecutor = executor.createPageExecutor(pageNumber, pageDesign);
        if (pageExecutor != null) {
            IPageContent pageContent = (IPageContent)pageExecutor.execute();
            if (pageContent != null) {
                DOMBuilderEmitter emitter = new DOMBuilderEmitter(pageContent);
                ReportExecutorUtil.executeAll(pageExecutor, emitter);
            }
            pageExecutor.close();
            return pageContent;
        }
        return null;
    }

    protected static void executeAll(IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            IContent childContent = childExecutor.execute();
            if (childContent != null) {
                ContentEmitterUtil.startContent(childContent, emitter);
            }
            ReportExecutorUtil.executeAll(childExecutor, emitter);
            if (childContent != null) {
                ContentEmitterUtil.endContent(childContent, emitter);
            }
            childExecutor.close();
        }
    }
}

