/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SpacingManager
extends AbstractLengthManager {
    protected static final StringMap values = new StringMap();
    String propertyName;

    static {
        values.put("normal", CSSValueConstants.NORMAL_VALUE);
    }

    public SpacingManager(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public Value getDefaultValue() {
        return CSSValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
            case 23: {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
        }
        return super.createValue(lu, engine);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1 && value.getPrimitiveType() == 21) {
            return CSSValueConstants.NUMBER_0;
        }
        return super.computeValue(elt, engine, idx, value);
    }
}

