/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.impl.internal.MethodIdentifier;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ClassMethodFieldBuffer {
    private static ClassMethodFieldBuffer instance;
    private Map<Class, Map<MethodIdentifier, Method>> classMethods = new HashMap<Class, Map<MethodIdentifier, Method>>();
    private Map<Class, Map<String, Field>> classFields = new HashMap<Class, Map<String, Field>>();

    private ClassMethodFieldBuffer() {
    }

    public static void createInstance() {
        instance = new ClassMethodFieldBuffer();
    }

    public static ClassMethodFieldBuffer getInstance() {
        return instance;
    }

    public static void release() {
        if (instance == null) {
            return;
        }
        for (Map<MethodIdentifier, Method> map : ClassMethodFieldBuffer.instance.classMethods.values()) {
            map.clear();
        }
        ClassMethodFieldBuffer.instance.classMethods.clear();
        for (Map<Object, AccessibleObject> map : ClassMethodFieldBuffer.instance.classFields.values()) {
            map.clear();
        }
        ClassMethodFieldBuffer.instance.classFields.clear();
        instance = null;
    }

    public Method getMethod(Class c, MethodIdentifier mi) throws OdaException {
        Method m = this.findMethod(c, mi);
        return m == null ? this.saveMethod(c, mi) : m;
    }

    public Field getField(Class c, String fieldName) throws OdaException {
        Field f = this.findField(c, fieldName);
        return f == null ? this.saveField(c, fieldName) : f;
    }

    private Method findMethod(Class c, MethodIdentifier mi) {
        assert (c != null && mi != null);
        Map<MethodIdentifier, Method> methods = this.classMethods.get(c);
        return methods == null ? null : methods.get(mi);
    }

    private Method saveMethod(Class c, MethodIdentifier mi) throws OdaException {
        assert (c != null && mi != null);
        try {
            Method m = c.getMethod(mi.getName(), mi.getParams());
            Map<MethodIdentifier, Method> methods = this.classMethods.get(c);
            if (methods == null) {
                methods = new HashMap<MethodIdentifier, Method>();
                this.classMethods.put(c, methods);
            }
            methods.put(mi, m);
            return m;
        }
        catch (SecurityException e) {
            throw new OdaException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OdaException((Throwable)e);
        }
    }

    private Field findField(Class c, String fieldName) {
        assert (c != null && fieldName != null);
        Map<String, Field> fields = this.classFields.get(c);
        return fields == null ? null : fields.get(fieldName);
    }

    private Field saveField(Class c, String fieldName) throws OdaException {
        assert (c != null && fieldName != null);
        try {
            Field f = c.getField(fieldName);
            Map<String, Field> fields = this.classFields.get(c);
            if (fields == null) {
                fields = new HashMap<String, Field>();
                this.classFields.put(c, fields);
            }
            fields.put(fieldName, f);
            return f;
        }
        catch (SecurityException e) {
            throw new OdaException((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new OdaException((Throwable)e);
        }
    }
}

