/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.GearCaracteristicExportRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;

public class GearCaracteristicExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<GearCaracteristicExportRow> {
    public GearCaracteristicExportModel(char separator, DecoratorService decoratorService) {
        super(separator);
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Code_PMFM", "caracteristic", "id");
        this.newColumnForExportByDecorator("Libelle_PMFM", "caracteristic", decoratorService.getDecoratorByType(Caracteristic.class));
        this.newColumnForExport("Valeur", "value", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
    }

    public void prepareRows(List<GearCaracteristicExportRow> rows, Cruise cruise, Gear gear) {
        CaracteristicMap caracteristics = gear.getCaracteristics();
        if (caracteristics != null) {
            for (Map.Entry entry : caracteristics.entrySet()) {
                Caracteristic caracteristic = (Caracteristic)entry.getKey();
                Serializable value = (Serializable)entry.getValue();
                GearCaracteristicExportRow row = new GearCaracteristicExportRow();
                row.setCruise(cruise);
                row.setGear(gear);
                row.setCaracteristic(caracteristic);
                row.setValue(value);
                rows.add(row);
            }
        }
    }
}

