/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.decorator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.decorator.PropertyDecorator;

public abstract class DecoratorMulti18nProvider {
    private static final Log log = LogFactory.getLog(DecoratorProvider.class);
    protected Map<Locale, Collection<DecoratorContext<?>>> decoratorContexts;

    protected abstract void loadDecorators(Locale var1);

    public <O> Decorator<O> getDecorator(Locale locale, O object) {
        return this.getDecorator(locale, object, null);
    }

    public <O> Decorator<O> getDecorator(Locale locale, O object, String name) {
        Class<?> k = object.getClass();
        return this.getDecoratorByType(locale, k, name);
    }

    public <O> Decorator<O> getDecoratorByType(Locale locale, Class<O> type) {
        return this.getDecoratorByType(locale, type, null);
    }

    public <O> Decorator<O> getDecoratorByType(Locale locale, Class<O> type, String name) {
        DecoratorContext<O> d = this.getDecoratorContext(locale, type, name, true);
        return d == null ? null : d.getDecorator();
    }

    public void registerPropertyDecorator(Locale locale, Class<?> klass, String expression) {
        this.registerPropertyDecorator(locale, klass, null, expression);
    }

    public void registerJXPathDecorator(Locale locale, Class<?> klass, String expression) {
        this.registerJXPathDecorator(locale, klass, null, expression);
    }

    public void registerMultiJXPathDecorator(Locale locale, Class<?> klass, String expression, String separator, String separatorReplacement) {
        this.registerMultiJXPathDecorator(locale, klass, null, expression, separator, separatorReplacement);
    }

    public void registerPropertyDecorator(Locale locale, Class<?> klass, String name, String expression) {
        PropertyDecorator<?> decorator = DecoratorUtil.newPropertyDecorator(klass, expression);
        this.registerDecorator(locale, name, decorator);
    }

    public void registerJXPathDecorator(Locale locale, Class<?> klass, String name, String expression) {
        JXPathDecorator<?> decorator = DecoratorUtil.newJXPathDecorator(klass, expression);
        this.registerDecorator(locale, name, decorator);
    }

    public void registerMultiJXPathDecorator(Locale locale, Class<?> klass, String name, String expression, String separator, String separatorReplacement) {
        MultiJXPathDecorator<?> decorator = DecoratorUtil.newMultiJXPathDecorator(klass, expression, separator, separatorReplacement);
        this.registerDecorator(locale, name, decorator);
    }

    public void registerDecorator(Locale locale, Decorator<?> decorator) {
        this.registerDecorator(locale, null, decorator);
    }

    public <T> void registerDecorator(Locale locale, String context, Decorator<T> decorator) {
        DecoratorContext<T> result = this.getDecoratorContext(locale, decorator.getType(), context, false);
        if (result != null) {
            throw new IllegalArgumentException("there is an already register decorator with context " + result);
        }
        DecoratorContext<T> decoratorContext = new DecoratorContext<T>(context, decorator);
        if (log.isDebugEnabled()) {
            log.debug(decoratorContext);
        }
        this.getDecoratorContexts(locale, false).add(decoratorContext);
    }

    public void clear() {
        if (this.decoratorContexts != null) {
            this.decoratorContexts.clear();
        }
    }

    protected Map<Locale, Collection<DecoratorContext<?>>> getDecoratorContexts() {
        if (this.decoratorContexts == null) {
            this.decoratorContexts = new HashMap();
        }
        return this.decoratorContexts;
    }

    protected Collection<DecoratorContext<?>> getDecoratorContexts(Locale locale, boolean doLoad) {
        Collection<DecoratorContext<?>> decoratorContexts = this.getDecoratorContexts().get(locale);
        if (decoratorContexts == null) {
            decoratorContexts = new ArrayList();
            this.getDecoratorContexts().put(locale, decoratorContexts);
            if (doLoad) {
                this.loadDecorators(locale);
            }
        }
        return decoratorContexts;
    }

    protected <T> DecoratorContext<T> getDecoratorContext(Locale locale, Class<T> type, String context, boolean doLoad) {
        DecoratorContext<T> result = null;
        Collection<DecoratorContext<?>> decoratorContexts = this.getDecoratorContexts(locale, doLoad);
        if (decoratorContexts != null) {
            for (DecoratorContext<T> decoratorContext : decoratorContexts) {
                if (type == null) {
                    if (!decoratorContext.accept(context)) continue;
                    result = decoratorContext;
                    break;
                }
                if (!decoratorContext.accept(type, context)) continue;
                result = decoratorContext;
                break;
            }
        }
        return result;
    }

    public static class DecoratorContext<T> {
        final String context;
        final Decorator<T> decorator;

        public DecoratorContext(String context, Decorator<T> decorator) {
            this.context = context;
            this.decorator = decorator;
        }

        public String getContext() {
            return this.context;
        }

        public Decorator<T> getDecorator() {
            return this.decorator;
        }

        public Class<T> getType() {
            return this.decorator.getType();
        }

        public boolean accept(Class<?> type, String context) {
            boolean accept = this.getType().isAssignableFrom(type) && this.accept(context);
            return accept;
        }

        public boolean accept(String context) {
            return this.context == null && context == null || this.context != null && this.context.equals(context);
        }

        public String toString() {
            return super.toString() + "<type: " + this.getType().getName() + ", context :" + this.context + ">";
        }
    }
}

