/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.ByteIterator;

public class InputStreamByteIterator
implements ByteIterator {
    private InputStream stream = null;
    private boolean nextAvailable = false;
    private int next;

    public InputStreamByteIterator(InputStream in) {
        this.stream = in;
    }

    public boolean hasNext() {
        this.ensureNextAvailable();
        return -1 != this.next;
    }

    public byte next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        this.nextAvailable = false;
        return (byte)this.next;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() is not supported here");
    }

    public static ByteIterator adapt(InputStream in) {
        return null == in ? null : new InputStreamByteIterator(in);
    }

    private void ensureNextAvailable() {
        if (!this.nextAvailable) {
            this.readNext();
        }
    }

    private void readNext() {
        try {
            this.next = this.stream.read();
            this.nextAvailable = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

