/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4.support;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.AsyncWebRequestInterceptor;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;

public class OpenSessionInViewInterceptor
implements AsyncWebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((WebRequest)request);
        if (asyncManager.hasConcurrentResult() && this.applySessionBindingInterceptor(asyncManager, participateAttributeName)) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else {
            this.logger.debug((Object)"Opening Hibernate Session in OpenSessionInViewInterceptor");
            Session session = this.openSession();
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)sessionHolder));
            asyncManager.registerCallableInterceptor((Object)participateAttributeName, (CallableProcessingInterceptor)new SessionBindingCallableInterceptor(sessionHolder));
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        if (!this.decrementParticipateCount(request)) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        }
    }

    private boolean decrementParticipateCount(WebRequest request) {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
        } else {
            request.removeAttribute(participateAttributeName, 0);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(WebRequest request) {
        if (!this.decrementParticipateCount(request)) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
    }

    protected Session openSession() throws DataAccessResourceFailureException {
        try {
            Session session = this.getSessionFactory().openSession();
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }

    private boolean applySessionBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((SessionBindingCallableInterceptor)asyncManager.getCallableInterceptor((Object)key)).initializeThread();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionBindingCallableInterceptor
    extends CallableProcessingInterceptorAdapter {
        private final SessionHolder sessionHolder;

        public SessionBindingCallableInterceptor(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
            this.initializeThread();
        }

        public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
            TransactionSynchronizationManager.unbindResource((Object)OpenSessionInViewInterceptor.this.getSessionFactory());
        }

        private void initializeThread() {
            TransactionSynchronizationManager.bindResource((Object)OpenSessionInViewInterceptor.this.getSessionFactory(), (Object)((Object)this.sessionHolder));
        }
    }
}

