/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;

public class Logger {
    public SimpleLog appLog = new SimpleLog(null, 0, false);
    private Log log;
    private LockFile lockFile;
    boolean needsCheckpoint;
    private boolean logStatements;
    private boolean syncFile = false;

    public void openLog(Database database) throws HsqlException {
        this.needsCheckpoint = false;
        String string = database.getPath();
        int n = database.getProperties().getIntegerProperty("hsqldb.applog", 0);
        if (n != 0) {
            this.appLog = new SimpleLog(string + ".app.log", n, !database.isFilesReadOnly());
        }
        this.appLog.sendLine(1, "Database (re)opened");
        this.logStatements = false;
        boolean bl = database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (bl && !database.isFilesReadOnly()) {
            this.acquireLock(string);
        }
        this.log = new Log(database);
        this.log.open();
        this.logStatements = !database.isFilesReadOnly();
    }

    public boolean closeLog(int n) {
        if (this.log == null) {
            this.appLog.sendLine(1, "Database closed");
            this.appLog.close();
            return true;
        }
        try {
            switch (n) {
                case -1: {
                    this.log.shutdown();
                    break;
                }
                case 0: {
                    this.log.close(false);
                    break;
                }
                case 1: 
                case 2: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, "error closing log");
            this.appLog.close();
            this.log = null;
            return false;
        }
        this.appLog.sendLine(1, "Database closed");
        this.appLog.close();
        this.log = null;
        return true;
    }

    public boolean hasLog() {
        return this.log != null;
    }

    public DataFileCache getCache() throws HsqlException {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void logConnectUser(Session session) throws HsqlException {
        if (this.logStatements) {
            this.writeToLog(session, session.getUser().getConnectStatement());
        }
    }

    public synchronized void writeToLog(Session session, String string) throws HsqlException {
        if (this.logStatements && this.log != null) {
            this.log.writeStatement(session, string);
        }
    }

    public synchronized void writeInsertStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.logStatements) {
            this.log.writeInsertStatement(session, table, objectArray);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.logStatements) {
            this.log.writeDeleteStatement(session, table, objectArray);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence numberSequence) throws HsqlException {
        if (this.logStatements) {
            this.log.writeSequenceStatement(session, numberSequence);
        }
    }

    public synchronized void writeCommitStatement(Session session) throws HsqlException {
        if (this.logStatements) {
            this.log.writeCommitStatement(session);
            this.synchLog();
        }
    }

    public synchronized void synchLog() {
        if (this.logStatements && this.syncFile) {
            this.log.synchLog();
        }
    }

    public synchronized void synchLogForce() {
        if (this.logStatements) {
            this.log.synchLog();
        }
    }

    public synchronized void checkpoint(boolean bl) throws HsqlException {
        if (this.logStatements) {
            this.appLog.logContext(2, "start");
            this.needsCheckpoint = false;
            this.log.checkpoint(bl);
            this.appLog.logContext(2, "end");
        }
    }

    public synchronized void setLogSize(int n) {
        if (this.log != null) {
            this.log.setLogSize(n);
        }
    }

    public synchronized void setScriptType(int n) throws HsqlException {
        if (this.log != null) {
            this.log.setScriptType(n);
        }
    }

    public synchronized void setWriteDelay(int n) {
        if (this.log != null) {
            this.syncFile = n == 0;
            this.log.setWriteDelay(n);
        }
    }

    public int getWriteDelay() {
        return this.log != null ? this.log.getWriteDelay() : 0;
    }

    public int getLogSize() {
        return this.log != null ? this.log.getLogSize() : 0;
    }

    public int getScriptType() {
        return this.log != null ? this.log.getScriptType() : 0;
    }

    public DataFileCache openTextCache(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        return this.log.openTextCache(table, string, bl, bl2);
    }

    public void closeTextCache(Table table) throws HsqlException {
        this.log.closeTextCache(table);
    }

    public boolean needsCheckpoint() {
        return this.needsCheckpoint;
    }

    public void acquireLock(String string) throws HsqlException {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(string);
    }

    public void releaseLock() {
        block3: {
            try {
                if (this.lockFile != null) {
                    this.lockFile.tryRelease();
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
        this.lockFile = null;
    }
}

