/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.xwork2.XWork2ScopeValidator;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public class XWork2NuitonValidator<O>
implements NuitonValidator<O> {
    protected NuitonValidatorModel<O> model;
    protected Map<NuitonValidatorScope, XWork2ScopeValidator<O>> validators;

    public XWork2NuitonValidator(NuitonValidatorModel<O> model) {
        this.model = model;
        this.validators = new EnumMap<NuitonValidatorScope, XWork2ScopeValidator<O>>(NuitonValidatorScope.class);
        Class<O> type = model.getType();
        String context = model.getContext();
        Map<NuitonValidatorScope, String[]> fieldsMap = model.getFields();
        for (Map.Entry<NuitonValidatorScope, String[]> entry : fieldsMap.entrySet()) {
            NuitonValidatorScope scope = entry.getKey();
            String scopeContext = XWork2ValidatorUtil.getContextForScope(context, scope);
            HashSet<Object> fields = new HashSet<Object>(Arrays.asList((Object[])entry.getValue()));
            XWork2ScopeValidator<O> newValidator = XWork2ValidatorUtil.newXWorkScopeValidator(type, scopeContext, fields);
            this.validators.put(scope, newValidator);
        }
    }

    @Override
    public NuitonValidatorResult validate(O object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException("object parameter can not be null.");
        }
        NuitonValidatorResult result = new NuitonValidatorResult();
        for (NuitonValidatorScope scope : this.validators.keySet()) {
            XWork2ScopeValidator<O> validator = this.validators.get((Object)scope);
            Map<String, List<String>> newMessages = validator.validate(object);
            result.addMessagesForScope(scope, newMessages);
        }
        return result;
    }

    @Override
    public Set<NuitonValidatorScope> getEffectiveScopes() {
        return this.validators.keySet();
    }

    @Override
    public Set<String> getEffectiveFields() {
        HashSet<String> result = new HashSet<String>();
        for (XWork2ScopeValidator<O> scopeValidator : this.validators.values()) {
            result.addAll(scopeValidator.getFieldNames());
        }
        return result;
    }

    @Override
    public Set<String> getEffectiveFields(NuitonValidatorScope scope) {
        HashSet<String> result = new HashSet<String>();
        XWork2ScopeValidator<O> scopeValidator = this.validators.get((Object)scope);
        if (scopeValidator != null) {
            result.addAll(scopeValidator.getFieldNames());
        }
        return result;
    }

    @Override
    public NuitonValidatorModel<O> getModel() {
        return this.model;
    }
}

