/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemThemeModel;
import org.eclipse.birt.report.model.elements.strategy.FlattenCopyPolicy;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class ReportItemTheme
extends AbstractTheme
implements IReportItemThemeModel {
    public ReportItemTheme() {
    }

    public ReportItemTheme(String theName) {
        super(theName);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitReportItemTheme(this);
    }

    @Override
    public String getElementName() {
        return "ReportItemTheme";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ReportItemThemeHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ReportItemThemeHandle(module, this);
        }
        return (ReportItemThemeHandle)this.handle;
    }

    public static boolean isValidType(String type) {
        if (StringUtil.isBlank(type)) {
            return false;
        }
        List<IPredefinedStyle> styles = MetaDataDictionary.getInstance().getPredefinedStyles(type);
        return styles != null && !styles.isEmpty();
    }

    public String getType(Module module) {
        return this.getStringProperty(module, "type");
    }

    public Object FlattenClone() throws CloneNotSupportedException {
        return this.doClone(FlattenCopyPolicy.getInstance());
    }
}

