/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModelCache;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.util.Weights;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class BenthosFrequencyUIModel
extends AbstractTuttiTableUIModel<BenthosBatchRowModel, BenthosFrequencyRowModel, BenthosFrequencyUIModel> {
    private static final Log log = LogFactory.getLog(BenthosFrequencyUIModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";
    public static final String PROPERTY_STEP = "step";
    private static final String PROPERTY_MIN_STEP = "minStep";
    private static final String PROPERTY_MAX_STEP = "maxStep";
    public static final String PROPERTY_CAN_GENERATE = "canGenerate";
    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";
    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";
    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";
    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT = "lengthStepCaracteristicUnit";
    public static final String PROPERTY_TOTAL_NUMBER = "totalNumber";
    public static final String PROPERTY_TOTAL_COMPUTED_OR_NOT_WEIGHT = "totalComputedOrNotWeight";
    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";
    public static final String PROPERTY_TOTAL_COMPUTED_WEIGHT = "totalComputedWeight";
    public static final String PROPERTY_EMPTY_ROWS = "emptyRows";
    public static final String PROPERTY_NEXT_EDITABLE_ROW_INDEX = "nextEditableRowIndex";
    public static final String PROPERTY_CAN_EDIT_LENGTH_STEP = "canEditLengthStep";
    protected FrequencyConfigurationMode configurationMode;
    protected BenthosBatchRowModel batch;
    protected Float step;
    protected Float minStep;
    protected Float maxStep;
    protected Caracteristic lengthStepCaracteristic;
    protected Integer simpleCount;
    protected Integer totalNumber;
    protected ComputableData<Float> totalComputedOrNotWeight = new ComputableData();
    protected Integer nextEditableRowIndex;
    protected Set<BenthosFrequencyRowModel> emptyRows;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected final BenthosFrequencyUIModelCache cache = new BenthosFrequencyUIModelCache();
    protected boolean canEditLengthStep = true;
    protected final XYSeriesCollection dataset;

    public BenthosFrequencyUIModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel) {
        super(BenthosBatchRowModel.class, null, null);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.totalComputedOrNotWeight.addPropagateListener(PROPERTY_TOTAL_WEIGHT, this);
        this.setEmptyRows(Sets.newHashSet());
        XYSeries series = new XYSeries((Comparable)((Object)""), true, false);
        this.dataset = new XYSeriesCollection(series);
        this.dataset.setIntervalPositionFactor(0.0);
        this.dataset.setIntervalWidth(0.0);
    }

    public void reloadRows() {
        this.setEmptyRows(Sets.newHashSet());
        XYSeries series = this.dataset.getSeries(0);
        series.clear();
        this.cache.loadCache(this.rows);
        this.recomputeRowsValidateState();
        if (this.rows != null) {
            for (BenthosFrequencyRowModel row : this.rows) {
                if (!row.isValid()) continue;
                Float lengthStep = row.getLengthStep();
                series.addOrUpdate((Number)lengthStep, (Number)row.getNumber());
            }
        }
        this.recomputeTotalNumberAndWeight();
    }

    public boolean isRowValid(BenthosFrequencyRowModel row) {
        boolean valid;
        boolean bl = valid = row.getLengthStepCaracteristic() != null;
        if (valid) {
            Float lengthStep = row.getLengthStep();
            boolean bl2 = valid = lengthStep != null && lengthStep.floatValue() > 0.0f && this.numberOfRows(lengthStep.floatValue()) < 2;
        }
        if (valid) {
            Integer number = row.getNumber();
            boolean bl3 = valid = number != null && number > 0;
        }
        if (valid) {
            Float weight = row.getWeight();
            valid = this.getNbRowsWithWeight() == 0 || weight != null && weight.floatValue() > 0.0f;
        }
        return valid;
    }

    @Override
    protected BenthosBatchRowModel newEntity() {
        return new BenthosBatchRowModel(this.weightUnit, this.sampleCategoryModel);
    }

    public FrequencyConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(FrequencyConfigurationMode configurationMode) {
        FrequencyConfigurationMode oldValue = this.getConfigurationMode();
        this.configurationMode = configurationMode;
        this.firePropertyChange(PROPERTY_CONFIGURATION_MODE, (Object)oldValue, (Object)configurationMode);
        this.firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, this.isAutoGenMode());
        this.firePropertyChange(PROPERTY_RAFALE_MODE, null, this.isRafaleMode());
        this.firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, this.isSimpleCountingMode());
    }

    public Float getStep() {
        return this.step;
    }

    public void setStep(Float step) {
        Float oldValue = this.getStep();
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT, null, this.getLengthStepCaracteristicUnit());
    }

    public String getLengthStepCaracteristicUnit() {
        return this.lengthStepCaracteristic == null ? null : this.lengthStepCaracteristic.getUnit();
    }

    public Float getLengthStepCaracteristicPrecision() {
        return this.lengthStepCaracteristic == null ? null : this.lengthStepCaracteristic.getPrecision();
    }

    public Float getMinStep() {
        return this.minStep;
    }

    public void setMinStep(Float minStep) {
        Float oldValue = this.getMinStep();
        this.minStep = minStep;
        this.firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Float oldValue = this.getMaxStep();
        this.maxStep = maxStep;
        this.firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Integer getSimpleCount() {
        return this.simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Integer oldValue = this.getSimpleCount();
        this.simpleCount = simpleCount;
        this.firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public boolean isCanEditLengthStep() {
        return this.canEditLengthStep;
    }

    public void setCanEditLengthStep(boolean canEditLengthStep) {
        Boolean oldValue = this.isCanEditLengthStep();
        this.canEditLengthStep = canEditLengthStep;
        this.firePropertyChange(PROPERTY_CAN_EDIT_LENGTH_STEP, oldValue, canEditLengthStep);
    }

    public Integer getNextEditableRowIndex() {
        return this.nextEditableRowIndex;
    }

    public void setNextEditableRowIndex(Integer nextEditableRowIndex) {
        Integer oldValue = this.getNextEditableRowIndex();
        this.nextEditableRowIndex = nextEditableRowIndex;
        this.firePropertyChange(PROPERTY_NEXT_EDITABLE_ROW_INDEX, oldValue, nextEditableRowIndex);
    }

    public boolean isAutoGenMode() {
        return FrequencyConfigurationMode.AUTO_GEN == this.configurationMode;
    }

    public boolean isRafaleMode() {
        return FrequencyConfigurationMode.RAFALE == this.configurationMode;
    }

    public boolean isSimpleCountingMode() {
        return FrequencyConfigurationMode.SIMPLE_COUNTING == this.configurationMode;
    }

    public boolean isCanGenerate() {
        return this.minStep != null && this.maxStep != null && this.maxStep.floatValue() > this.minStep.floatValue() && this.lengthStepCaracteristic != null;
    }

    public BenthosBatchRowModel getBatch() {
        return this.batch;
    }

    public void setBatch(BenthosBatchRowModel batch) {
        this.batch = batch;
        this.firePropertyChange(PROPERTY_BATCH, null, batch);
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int)(lengthStep * 10.0f);
        int intStep = (int)(this.step.floatValue() * 10.0f);
        int correctIntStep = intValue - intValue % intStep;
        float result = (float)correctIntStep / 10.0f;
        return result;
    }

    public Integer getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        Integer oldValue = this.getTotalNumber();
        this.totalNumber = totalNumber;
        this.firePropertyChange(PROPERTY_TOTAL_NUMBER, oldValue, totalNumber);
    }

    public ComputableData<Float> getTotalComputedOrNotWeight() {
        return this.totalComputedOrNotWeight;
    }

    public void setTotalComputedOrNotWeight(ComputableData<Float> totalComputedOrNotWeight) {
        ComputableData<Float> oldValue = this.getTotalComputedOrNotWeight();
        this.totalComputedOrNotWeight = totalComputedOrNotWeight;
        this.firePropertyChange(PROPERTY_TOTAL_COMPUTED_OR_NOT_WEIGHT, oldValue, totalComputedOrNotWeight);
    }

    public Float getTotalWeight() {
        return this.totalComputedOrNotWeight.getData();
    }

    public void setTotalWeight(Float totalWeight) {
        Float oldValue = this.getTotalWeight();
        this.totalComputedOrNotWeight.setData(totalWeight);
        this.firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getTotalComputedWeight() {
        return this.totalComputedOrNotWeight.getComputedData();
    }

    public void setTotalComputedWeight(Float totalComputedWeight) {
        Float oldValue = this.getTotalComputedWeight();
        this.totalComputedOrNotWeight.setComputedData(totalComputedWeight);
        this.firePropertyChange(PROPERTY_TOTAL_COMPUTED_WEIGHT, oldValue, totalComputedWeight);
    }

    public boolean isTotalWeightSameAsComputedWeight() {
        Float totalWeight = this.getTotalWeight();
        Float computedWeight = this.getTotalComputedWeight();
        return totalWeight != null && computedWeight != null && Weights.isEqualWeight(totalWeight.floatValue(), computedWeight.floatValue());
    }

    public Set<BenthosFrequencyRowModel> getEmptyRows() {
        return this.emptyRows;
    }

    public void setEmptyRows(Set<BenthosFrequencyRowModel> emptyRows) {
        this.emptyRows = emptyRows;
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, emptyRows);
    }

    public int getNbRowsWithWeight() {
        return this.cache.getNbRowsWithWeight();
    }

    public boolean isAllRowsWithWeight() {
        return this.cache.getNbRowsWithWeight() == this.rows.size();
    }

    public boolean isSomeRowsWithWeightAndOtherWithout() {
        boolean result;
        if (CollectionUtils.isEmpty((Collection)this.rows)) {
            result = false;
        } else {
            int nbNoneEmptyRows = 0;
            int nbNoneEmptyRowsWithWeight = 0;
            for (BenthosFrequencyRowModel row : this.rows) {
                if (row.isEmpty()) continue;
                ++nbNoneEmptyRows;
                if (row.getWeight() == null) continue;
                ++nbNoneEmptyRowsWithWeight;
            }
            result = nbNoneEmptyRowsWithWeight > 0 && nbNoneEmptyRows != nbNoneEmptyRowsWithWeight;
        }
        return result;
    }

    public void updateEmptyRow(BenthosFrequencyRowModel row) {
        if (row.isValid() && row.getNumber() == null && row.getWeight() == null) {
            this.emptyRows.add(row);
        } else {
            this.emptyRows.remove(row);
        }
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    public int computeTotalNumber() {
        int result = 0;
        if (this.rows != null) {
            for (BenthosFrequencyRowModel row : this.rows) {
                if (!row.isValid() || row.getNumber() == null) continue;
                result += row.getNumber().intValue();
            }
        }
        return result;
    }

    public void recomputeTotalNumberAndWeight() {
        int computeTotalNumber = this.computeTotalNumber();
        Float computeTotalWeight = this.cache.computeTotalWeight();
        this.setTotalNumber(computeTotalNumber);
        this.setTotalComputedWeight(computeTotalWeight);
    }

    public void recomputeCanEditLengthStep() {
        boolean result = true;
        for (BenthosFrequencyRowModel row : this.rows) {
            if (row.isEmpty() || row.getLengthStep() == null || row.getNumber() == null) continue;
            result = false;
        }
        this.setCanEditLengthStep(result);
    }

    public int numberOfRows(float lengthStep) {
        return this.cache.numberOfRows(lengthStep);
    }

    public Map<Float, BenthosFrequencyRowModel> getRowCache() {
        return this.cache.getRowCache();
    }

    protected final void recomputeRowValidState(BenthosFrequencyRowModel row) {
        boolean valid = this.isRowValid(row);
        row.setValid(valid);
        if (valid) {
            this.removeRowInError(row);
        } else {
            this.addRowInError(row);
        }
    }

    public void recomputeRowsValidateState() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Revalidate all rows");
        }
        for (BenthosFrequencyRowModel r : this.rows) {
            this.recomputeRowValidState(r);
        }
    }

    public void setDataSetIntervalWidth(float step) {
        this.dataset.setIntervalWidth((double)step);
    }
}

