/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.action.ExportDbAction;
import fr.ifremer.tutti.ui.swing.action.InstallDbAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import java.util.Date;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;

public class ReinstallDbAction
extends AbstractMainUITuttiAction {
    protected File backupFile;
    protected String jdbcUrl;

    public ReinstallDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            doAction = context.checkUpdateDataReachable(true);
        }
        if (doAction) {
            this.jdbcUrl = null;
            this.backupFile = null;
            this.jdbcUrl = this.getConfig().getJdbcUrl();
            if (((TuttiUIContext)this.getModel()).isDbExist()) {
                this.displayInfoMessage(I18n.t((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.installDb.backup.db", (Object[])new Object[0]));
                this.backupFile = this.saveFile(this.getConfig().getDbBackupDirectory(), "tutti-db-" + ExportDbAction.df.format(new Date()), "zip", I18n.t((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), new String[]{"^.*\\.zip", I18n.t((String)"tutti.common.file.zip", (Object[])new Object[0])});
                if (this.backupFile == null) {
                    this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.installDb.no.backup.db.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
        }
        if (doAction) {
            ProgressionModel progressionModel = new ProgressionModel();
            progressionModel.setTotal(3);
            this.setProgressionModel(progressionModel);
        }
        return doAction;
    }

    @Override
    public void doAction() {
        Preconditions.checkNotNull((Object)this.backupFile);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n.t((String)"tutti.reinstallDb.step.closeDb", (Object[])new Object[]{this.jdbcUrl}));
        this.getContext().closePersistenceService();
        progressionModel.increments(I18n.t((String)"tutti.reinstallDb.step.backupDb", (Object[])new Object[]{this.backupFile}));
        this.getContext().getPersistenceService().exportDb(this.backupFile);
        this.getContext().clearDbContext();
        String actionContent = InstallDbAction.class.getName();
        File startActionFile = this.getConfig().getStartActionFile();
        ApplicationIOUtil.writeContent((File)startActionFile, (String)actionContent, (String)I18n.t((String)"tutti.error.write.startActionFile", (Object[])new Object[]{startActionFile}));
        this.getContext().deleteDbOnExit();
        progressionModel.increments(I18n.t((String)"tutti.reinstallDb.step.reloadApplication", (Object[])new Object[0]));
        RunTutti.closeTutti((MainUIHandler)this.getHandler(), 88);
    }
}

