/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class ExportGenericFormatCruiseAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportGenericFormatCruiseAction.class);
    protected File file;

    public ExportGenericFormatCruiseAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
            this.file = this.saveFileWithStartDirectory(this.getConfig().getExportBackupDirectory(), false, "exportCruise-" + cruise.getName(), "zip", I18n.t((String)"tutti.selectCruise.title.choose.exportCruiseFile", (Object[])new Object[0]), I18n.t((String)"tutti.selectCruise.action.chooseCruiseExportFile", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.genericFormat", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = ((SelectCruiseUIModel)this.getModel()).getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save cruise " + cruise.getId() + " to file: " + this.file));
        }
        GenericFormatExportService service = this.getContext().getGenericFormatExportService();
        this.createProgressionModelIfRequired(1);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n.t((String)"tutti.exportCruise.action.computeNbSteps", (Object[])new Object[0]));
        int nbSteps = service.getExportCruiseNbSteps(cruise.getId());
        progressionModel.adaptTotal(nbSteps);
        ApplicationBusinessException exportError = null;
        try {
            service.exportCruise(cruise.getId(), this.file, progressionModel);
            this.sendMessage(I18n.t((String)"tutti.exportCruise.action.success", (Object[])new Object[]{cruise.getName(), this.file.getName()}));
        }
        catch (ApplicationBusinessException e) {
            String errorMessage = I18n.t((String)"tutti.exportCruise.action.exportErrors", (Object[])new Object[]{cruise.getName(), e.getMessage()});
            exportError = new ApplicationBusinessException(errorMessage);
        }
        ((SelectCruiseUIHandler)this.handler).resetEditCruiseAction();
        if (exportError != null) {
            throw exportError;
        }
    }
}

