/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryPerson;
import fr.ifremer.tutti.service.referential.csv.PersonRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryPerson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryPersonService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryPersonService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportRequest<Person, Integer> createReferentialImportRequest() {
        List<Person> allPersons = this.persistenceService.getAllPerson();
        ReferentialImportRequest<Person, Integer> requestResult = new ReferentialImportRequest<Person, Integer>(allPersons, TuttiEntities.newIdAstIntFunction(), Persons.GET_FULL_NAME);
        return requestResult;
    }

    public ReferentialImportResult<Person> importTemporaryPerson(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import persons from file: " + file));
        }
        ReferentialImportRequest<Person, Integer> requestResult = this.createReferentialImportRequest();
        try (CsvConsumerForTemporaryPerson consumer = new CsvConsumerForTemporaryPerson(file.toPath(), this.getCsvSeparator(), true);){
            for (ImportRow bean : consumer) {
                consumer.checkRow(bean, this.persistenceService, this.decoratorService, requestResult);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.persons.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        ReferentialImportResult<Person> result = this.executeImportRequest(requestResult);
        return result;
    }

    public ReferentialImportResult<Person> executeImportRequest(ReferentialImportRequest<Person, Integer> requestResult) {
        ReferentialImportResult<Person> result = new ReferentialImportResult<Person>();
        if (requestResult.withEntitiesToDelete()) {
            List<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryPersons(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            List<Person> entitiesToAdd = requestResult.getEntitiesToAdd();
            List<Person> entitiesAdded = this.persistenceService.addTemporaryPersons(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            List<Person> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            List<Person> entitiesUpdated = this.persistenceService.updateTemporaryPersons(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        if (requestResult.withEntitiesToLink()) {
            List<Person> entitiesToLink = requestResult.getEntitiesToLink();
            List<Person> entitiesLinked = this.persistenceService.linkTemporaryPersons(entitiesToLink);
            result.addAllRefsLinked(entitiesLinked);
        }
        return result;
    }

    public List<Person> getTemporaryPersons() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all persons from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllPerson());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " persons"));
        }
        List<Person> toExport = this.persistenceService.retainTemporaryPersonList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary persons"));
        }
        return toExport;
    }

    public void exportExistingTemporaryPerson(File file) throws IOException {
        List<Person> toExport = this.getTemporaryPersons();
        this.exportTemporaryPerson(file, toExport);
    }

    public void exportTemporaryPersonExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Person p = Persons.newPerson();
        p.setFirstName("First name 1");
        p.setLastName("Last name 1");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 2");
        p.setLastName("Last name 2");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 3");
        p.setLastName("Last name 3");
        toExport.add(p);
        this.exportTemporaryPerson(file, toExport);
    }

    public void exportTemporaryPerson(File file, List<Person> toExport) throws IOException {
        try (CsvProducerForTemporaryPerson producerForTemporarySpecies = new CsvProducerForTemporaryPerson(file.toPath(), this.getCsvSeparator());){
            List<PersonRow> dataToExport = producerForTemporarySpecies.getDataToExport(toExport);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.person.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return ';';
    }
}

