/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class JoinConditionHandle
extends StructureHandle {
    public JoinConditionHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public void setJoinType(String type) throws SemanticException {
        this.setProperty("joinType", type);
    }

    public String getJoinType() {
        return this.getStringProperty("joinType");
    }

    public void setOperator(String operator) throws SemanticException {
        this.setProperty("joinOperator", operator);
    }

    public String getOperator() {
        return this.getStringProperty("joinOperator");
    }

    public void setLeftDataSet(String leftDataset) {
        this.setPropertySilently("leftDataSet", leftDataset);
    }

    public String getLeftDataSet() {
        return this.getStringProperty("leftDataSet");
    }

    public void setRightDataSet(String rightDataset) {
        this.setPropertySilently("rightDataSet", rightDataset);
    }

    public String getRightDataSet() {
        return this.getStringProperty("rightDataSet");
    }

    public void setLeftExpression(String leftExpression) {
        this.setPropertySilently("leftExpression", leftExpression);
    }

    public String getLeftExpression() {
        return this.getStringProperty("leftExpression");
    }

    public void setRightExpression(String rightExpression) {
        this.setPropertySilently("rightExpression", rightExpression);
    }

    public String getRightExpression() {
        return this.getStringProperty("rightExpression");
    }

    @Override
    public Object getProperty(String memberName) {
        if (!"leftDataSet".equals(memberName) && !"rightDataSet".equals(memberName)) {
            return super.getProperty(memberName);
        }
        return this.getPrefixStringProperty(memberName);
    }

    @Override
    protected String getStringProperty(String memberName) {
        return this.getPrefixStringProperty(memberName);
    }

    private String getPrefixStringProperty(String memberName) {
        if (!"leftDataSet".equalsIgnoreCase(memberName) && !"rightDataSet".equalsIgnoreCase(memberName)) {
            return super.getStringProperty(memberName);
        }
        String dataSetName = super.getStringProperty(memberName);
        if (StringUtil.isBlank(dataSetName)) {
            return dataSetName;
        }
        List<Object> dataSetRefs = this.elementHandle.getElement().getListProperty(this.getModule(), "dataSets");
        if (dataSetRefs == null || dataSetRefs.isEmpty()) {
            return dataSetName;
        }
        Module tmpRoot = null;
        int j = 0;
        while (j < dataSetRefs.size()) {
            ElementRefValue tmpRefValue = (ElementRefValue)dataSetRefs.get(j);
            if (tmpRefValue.getName().equalsIgnoreCase(dataSetName) && tmpRefValue.getElement() != null) {
                tmpRoot = tmpRefValue.getElement().getRoot();
                break;
            }
            ++j;
        }
        if (tmpRoot instanceof Library) {
            return StringUtil.buildQualifiedReference(((Library)tmpRoot).getNamespace(), dataSetName);
        }
        return dataSetName;
    }
}

