/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SpeciesMap {
    protected final Map<Integer, SpeciesProtocol> speciesProtocolMap;
    protected final Map<Integer, SpeciesProtocol> benthosProtocolMap;
    protected final Map<Integer, Species> speciesByReferenceTaxonId = new TreeMap<Integer, Species>();
    protected final PersistenceService persistenceService;

    public static SpeciesMap create(TuttiDataContext dataContext, PersistenceService persistenceService) {
        Map<Integer, SpeciesProtocol> benthosProtocolMap;
        Map<Integer, SpeciesProtocol> speciesProtocolMap;
        boolean protocolFilled = dataContext.isProtocolFilled();
        if (protocolFilled) {
            speciesProtocolMap = persistenceService.toSpeciesProtocolMap();
            benthosProtocolMap = persistenceService.toBenthosProtocolMap();
        } else {
            speciesProtocolMap = new HashMap<Integer, SpeciesProtocol>();
            benthosProtocolMap = new HashMap<Integer, SpeciesProtocol>();
        }
        SpeciesMap speciesMap = new SpeciesMap(persistenceService, speciesProtocolMap, benthosProtocolMap);
        return speciesMap;
    }

    public <A extends SpeciesAbleBatch> void loadSpecies(List<A> speciesAbleBatches) {
        for (SpeciesAbleBatch speciesAbleBatch : speciesAbleBatches) {
            this.loadSpecies(speciesAbleBatch.getSpecies());
        }
    }

    public <A extends SpeciesAbleBatch> void loadBenthos(List<A> speciesAbleBatches) {
        for (SpeciesAbleBatch speciesAbleBatch : speciesAbleBatches) {
            this.loadBenthos(speciesAbleBatch.getSpecies());
        }
    }

    public void loadSpecies(Species species) {
        this.load(species, this.speciesProtocolMap);
    }

    public void loadBenthos(Species species) {
        this.load(species, this.benthosProtocolMap);
    }

    protected SpeciesMap(PersistenceService persistenceService, Map<Integer, SpeciesProtocol> speciesProtocolMap, Map<Integer, SpeciesProtocol> benthosProtocolMap) {
        this.speciesProtocolMap = speciesProtocolMap;
        this.benthosProtocolMap = benthosProtocolMap;
        this.persistenceService = persistenceService;
    }

    protected void load(Species species, Map<Integer, SpeciesProtocol> protocolMap) {
        Integer referenceTaxonId = species.getReferenceTaxonId();
        Species speciesLoaded = this.speciesByReferenceTaxonId.get(referenceTaxonId);
        if (speciesLoaded == null) {
            Species speciesWithVerncularCode = this.persistenceService.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
            species.setVernacularCode(speciesWithVerncularCode.getVernacularCode());
            if (protocolMap.containsKey(species.getReferenceTaxonId())) {
                SpeciesProtocol speciesProtocol = protocolMap.get(species.getReferenceTaxonId());
                String surveyCode = speciesProtocol.getSpeciesSurveyCode();
                species.setSurveyCode(surveyCode);
            }
            this.speciesByReferenceTaxonId.put(species.getReferenceTaxonId(), species);
        } else {
            species.setVernacularCode(speciesLoaded.getVernacularCode());
            species.setSurveyCode(speciesLoaded.getSurveyCode());
        }
    }
}

